/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.io.IOException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.CredentialStoreSpi;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.credential.store._private.ElytronMessages;

public final class MapCredentialStore
extends CredentialStoreSpi {
    public static final String MAP_CREDENTIAL_STORE = "MapCredentialStore";
    private final Map<String, CredentialSource> credentialSources;
    private final boolean modifiable;

    public MapCredentialStore(ConcurrentMap<String, CredentialSource> credentialSources, boolean modifiable) {
        this.credentialSources = credentialSources;
        this.modifiable = modifiable;
    }

    public MapCredentialStore(Map<String, CredentialSource> credentialSources) {
        this.credentialSources = credentialSources;
        this.modifiable = false;
    }

    public MapCredentialStore() {
        this(new ConcurrentHashMap<String, CredentialSource>(), true);
    }

    @Override
    public void initialize(Map<String, String> attributes, CredentialStore.ProtectionParameter protectionParameter, Provider[] providers) throws CredentialStoreException {
        if (protectionParameter != null) {
            throw ElytronMessages.log.invalidProtectionParameter(protectionParameter);
        }
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public Set<String> getAliases() throws UnsupportedOperationException, CredentialStoreException {
        return new HashSet<String>(this.credentialSources.keySet());
    }

    @Override
    public boolean exists(String credentialAlias, Class<? extends Credential> credentialType) throws CredentialStoreException {
        try {
            return this.credentialSources.getOrDefault(credentialAlias, CredentialSource.NONE).getCredentialAcquireSupport(credentialType).mayBeSupported();
        }
        catch (IOException e) {
            throw ElytronMessages.log.cannotAcquireCredentialFromStore(e);
        }
    }

    @Override
    public void store(String credentialAlias, Credential credential, CredentialStore.ProtectionParameter protectionParameter) throws CredentialStoreException, UnsupportedCredentialTypeException {
        if (!this.isModifiable()) {
            throw ElytronMessages.log.nonModifiableCredentialStore("store");
        }
        this.credentialSources.compute(credentialAlias, (alias, old) -> {
            if (old instanceof IdentityCredentials) {
                return ((IdentityCredentials)old).withCredential(credential);
            }
            IdentityCredentials newVal = IdentityCredentials.NONE.withCredential(credential);
            if (old == null) {
                return newVal;
            }
            return old.with((CredentialSource)newVal);
        });
    }

    @Override
    public <C extends Credential> C retrieve(String credentialAlias, Class<C> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec, CredentialStore.ProtectionParameter protectionParameter) throws CredentialStoreException {
        try {
            return (C)this.credentialSources.getOrDefault(credentialAlias, CredentialSource.NONE).getCredential(credentialType, credentialAlgorithm, parameterSpec);
        }
        catch (IOException e) {
            throw ElytronMessages.log.cannotAcquireCredentialFromStore(e);
        }
    }

    @Override
    public void remove(String credentialAlias, Class<? extends Credential> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec) throws CredentialStoreException {
        if (!this.isModifiable()) {
            throw ElytronMessages.log.nonModifiableCredentialStore("remove");
        }
        this.credentialSources.computeIfPresent(credentialAlias, (alias, old) -> old.without(credentialType, credentialAlgorithm, parameterSpec));
    }
}

