/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class RemoveAuthorizationModule
implements OnlineCommand,
OfflineCommand {
    private final String securityDomainName;
    private final String authorizationModuleName;

    public RemoveAuthorizationModule(String securityDomainName, String authorizationModuleName) {
        if (securityDomainName == null) {
            throw new IllegalArgumentException("Name of the security-domain must be specified as non null value");
        }
        if (securityDomainName.isEmpty()) {
            throw new IllegalArgumentException("Name of the security-domain must not be empty value");
        }
        if (authorizationModuleName == null) {
            throw new IllegalArgumentException("Name of the policy-module must be specified as non null value");
        }
        if (authorizationModuleName.isEmpty()) {
            throw new IllegalArgumentException("Name of the policy-module must not be empty value");
        }
        this.securityDomainName = securityDomainName;
        this.authorizationModuleName = authorizationModuleName;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        Operations ops = new Operations(ctx.client);
        ops.remove(Address.subsystem((String)"security").and("security-domain", this.securityDomainName).and("authorization", "classic").and("policy-module", this.authorizationModuleName));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(RemoveAuthorizationModule.class).subtree("securitySubsystem", Subtree.subsystem("security")).parameter("atrSecurityDomainName", this.securityDomainName).parameter("atrAuthorizationModuleName", this.authorizationModuleName).build()});
    }
}

