/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.IOException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.PropertyPermission;
import java.util.function.Consumer;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.DelegatingClassTransformer;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.VFSResourceLoader;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ModuleDefinition;
import org.jboss.as.server.moduleservice.ModuleLoadService;
import org.jboss.as.server.moduleservice.ModuleResolvePhaseService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ClassTransformer;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.security.FactoryPermissionCollection;
import org.jboss.modules.security.ImmediatePermissionFactory;
import org.jboss.modules.security.PermissionFactory;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFilePermission;

public class ModuleSpecProcessor
implements DeploymentUnitProcessor {
    private static final ServerLogger logger = ServerLogger.DEPLOYMENT_LOGGER;
    private static final Permissions DEFAULT_PERMISSIONS;

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(Attachments.MODULE)) {
            return;
        }
        this.deployModuleSpec(phaseContext);
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.MODULE);
        deploymentUnit.removeAttachment(Attachments.MODULE_PERMISSIONS);
        deploymentUnit.removeAttachment(DelegatingClassTransformer.ATTACHMENT_KEY);
    }

    private void deployModuleSpec(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ModuleIdentifier moduleIdentifier;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parentDeployment = deploymentUnit.getParent();
        ResourceRoot mainRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (mainRoot == null) {
            return;
        }
        ModuleSpecification moduleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ArrayList<ResourceRoot> resourceRoots = new ArrayList<ResourceRoot>();
        if (ModuleRootMarker.isModuleRoot(mainRoot)) {
            resourceRoots.add(mainRoot);
        }
        List<ResourceRoot> additionalRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot additionalRoot : additionalRoots) {
            if (!ModuleRootMarker.isModuleRoot(additionalRoot) || SubDeploymentMarker.isSubDeployment(additionalRoot)) continue;
            resourceRoots.add(additionalRoot);
        }
        ArrayList<ResourceRoot> parentResourceRoots = new ArrayList<ResourceRoot>();
        if (parentDeployment != null) {
            List<ResourceRoot> additionalParentRoots = parentDeployment.getAttachmentList(Attachments.RESOURCE_ROOTS);
            for (ResourceRoot resourceRoot : additionalParentRoots) {
                if (!ModuleRootMarker.isModuleRoot(resourceRoot) || SubDeploymentMarker.isSubDeployment(resourceRoot)) continue;
                parentResourceRoots.add(resourceRoot);
            }
        }
        if ((moduleIdentifier = deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER)) == null) {
            throw ServerLogger.ROOT_LOGGER.noModuleIdentifier(deploymentUnit.getName());
        }
        ServiceName moduleServiceName = this.createModuleService(phaseContext, deploymentUnit, resourceRoots, parentResourceRoots, moduleSpec, moduleIdentifier);
        phaseContext.addDeploymentDependency(moduleServiceName, Attachments.MODULE);
        for (DeploymentUnit subDeployment : deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS)) {
            ModuleIdentifier moduleId = subDeployment.getAttachment(Attachments.MODULE_IDENTIFIER);
            if (moduleId == null) continue;
            phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, ServiceModuleLoader.moduleSpecServiceName(moduleId));
        }
        if (parentDeployment == null) {
            List<AdditionalModuleSpecification> list = deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_MODULES);
            for (AdditionalModuleSpecification module : list) {
                this.addAllDependenciesAndPermissions(moduleSpec, module);
                List<ResourceRoot> roots = module.getResourceRoots();
                ServiceName serviceName = this.createModuleService(phaseContext, deploymentUnit, roots, parentResourceRoots, module, module.getModuleIdentifier());
                phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, serviceName);
            }
        }
    }

    private void addAllDependenciesAndPermissions(ModuleSpecification moduleSpecification, AdditionalModuleSpecification module) {
        module.addSystemDependencies(moduleSpecification.getSystemDependencies());
        module.addLocalDependencies(moduleSpecification.getLocalDependencies());
        for (ModuleDependency dep : moduleSpecification.getUserDependencies()) {
            if (dep.getIdentifier().equals(module.getModuleIdentifier())) continue;
            module.addUserDependency(dep);
        }
        for (PermissionFactory factory : moduleSpecification.getPermissionFactories()) {
            module.addPermissionFactory(factory);
        }
    }

    private ServiceName createModuleService(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, List<ResourceRoot> resourceRoots, List<ResourceRoot> parentResourceRoots, ModuleSpecification moduleSpecification, ModuleIdentifier moduleIdentifier) throws DeploymentUnitProcessingException {
        logger.debugf("Creating module: %s", moduleIdentifier);
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)moduleIdentifier);
        for (DependencySpec dep : moduleSpecification.getModuleSystemDependencies()) {
            specBuilder.addDependency(dep);
        }
        List<ModuleDependency> dependencies = moduleSpecification.getSystemDependencies();
        List<ModuleDependency> localDependencies = moduleSpecification.getLocalDependencies();
        List<ModuleDependency> userDependencies = moduleSpecification.getUserDependencies();
        List<PermissionFactory> permFactories = moduleSpecification.getPermissionFactories();
        this.installAliases(moduleSpecification, moduleIdentifier, deploymentUnit, phaseContext);
        for (ResourceLoaderSpec resourceLoaderSpec : moduleSpecification.getResourceLoaders()) {
            logger.debugf("Adding resource loader %s to module %s", resourceLoaderSpec, moduleIdentifier);
            specBuilder.addResourceRoot(resourceLoaderSpec);
        }
        for (ResourceRoot resourceRoot : resourceRoots) {
            logger.debugf("Adding resource %s to module %s", resourceRoot.getRoot(), moduleIdentifier);
            this.addResourceRoot(specBuilder, resourceRoot, permFactories);
        }
        this.createDependencies(specBuilder, dependencies, false);
        this.createDependencies(specBuilder, userDependencies, false);
        if (moduleSpecification.isLocalLast()) {
            this.createDependencies(specBuilder, localDependencies, moduleSpecification.isLocalDependenciesTransitive());
            specBuilder.addDependency(DependencySpec.createLocalDependencySpec());
        } else {
            specBuilder.addDependency(DependencySpec.createLocalDependencySpec());
            this.createDependencies(specBuilder, localDependencies, moduleSpecification.isLocalDependenciesTransitive());
        }
        Enumeration<Permission> e = DEFAULT_PERMISSIONS.elements();
        while (e.hasMoreElements()) {
            permFactories.add((PermissionFactory)new ImmediatePermissionFactory(e.nextElement()));
        }
        for (ResourceRoot additionalParentRoot : parentResourceRoots) {
            VirtualFile root = additionalParentRoot.getRoot();
            permFactories.add((PermissionFactory)new ImmediatePermissionFactory((Permission)new VirtualFilePermission(root.getPathName(), VirtualFilePermission.FLAG_READ)));
            permFactories.add((PermissionFactory)new ImmediatePermissionFactory((Permission)new VirtualFilePermission(root.getChild("-").getPathName(), VirtualFilePermission.FLAG_READ)));
        }
        FactoryPermissionCollection factoryPermissionCollection = new FactoryPermissionCollection(permFactories.toArray(new PermissionFactory[permFactories.size()]));
        specBuilder.setPermissionCollection((PermissionCollection)factoryPermissionCollection);
        deploymentUnit.putAttachment(Attachments.MODULE_PERMISSIONS, factoryPermissionCollection);
        DelegatingClassTransformer delegatingClassTransformer = new DelegatingClassTransformer();
        specBuilder.setClassFileTransformer((ClassTransformer)delegatingClassTransformer);
        deploymentUnit.putAttachment(DelegatingClassTransformer.ATTACHMENT_KEY, delegatingClassTransformer);
        ModuleSpec moduleSpec = specBuilder.create();
        ServiceName moduleSpecServiceName = ServiceModuleLoader.moduleSpecServiceName(moduleIdentifier);
        ModuleDefinition moduleDefinition = new ModuleDefinition(moduleIdentifier, new HashSet<ModuleDependency>(moduleSpecification.getAllDependencies()), moduleSpec);
        ServiceBuilder sb = phaseContext.getServiceTarget().addService(moduleSpecServiceName);
        Consumer moduleDefinitionConsumer = sb.provides(new ServiceName[]{moduleSpecServiceName});
        sb.requires(deploymentUnit.getServiceName());
        sb.requires(phaseContext.getPhaseServiceName());
        sb.setInitialMode(ServiceController.Mode.ON_DEMAND);
        sb.setInstance((Service)new ModuleDefinitionService(moduleDefinitionConsumer, moduleDefinition));
        sb.install();
        ModuleResolvePhaseService.installService(phaseContext.getServiceTarget(), moduleDefinition);
        return ModuleLoadService.install(phaseContext.getServiceTarget(), moduleIdentifier, dependencies, localDependencies, userDependencies);
    }

    private void installAliases(ModuleSpecification moduleSpecification, ModuleIdentifier moduleIdentifier, DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext) {
        ModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        for (ModuleIdentifier alias : moduleSpecification.getAliases()) {
            ServiceName moduleSpecServiceName = ServiceModuleLoader.moduleSpecServiceName(alias);
            ModuleSpec spec = ModuleSpec.buildAlias((ModuleIdentifier)alias, (ModuleIdentifier)moduleIdentifier).create();
            HashSet<ModuleDependency> dependencies = new HashSet<ModuleDependency>(moduleSpecification.getAllDependencies());
            dependencies.add(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, false, false));
            ModuleDefinition moduleDefinition = new ModuleDefinition(alias, dependencies, spec);
            ServiceBuilder sb = phaseContext.getServiceTarget().addService(moduleSpecServiceName);
            Consumer moduleDefinitionConsumer = sb.provides(new ServiceName[]{moduleSpecServiceName});
            sb.requires(deploymentUnit.getServiceName());
            sb.requires(phaseContext.getPhaseServiceName());
            sb.setInitialMode(ServiceController.Mode.ON_DEMAND);
            sb.setInstance((Service)new ModuleDefinitionService(moduleDefinitionConsumer, moduleDefinition));
            sb.install();
            ModuleLoadService.installAliases(phaseContext.getServiceTarget(), alias, Collections.singletonList(moduleIdentifier));
            ModuleResolvePhaseService.installService(phaseContext.getServiceTarget(), moduleDefinition);
        }
    }

    private void createDependencies(ModuleSpec.Builder specBuilder, List<ModuleDependency> apiDependencies, boolean requireTransitive) {
        if (apiDependencies != null) {
            for (ModuleDependency dependency : apiDependencies) {
                PathFilter exportFilter;
                boolean export = requireTransitive ? true : dependency.isExport();
                List<FilterSpecification> importFilters = dependency.getImportFilters();
                List<FilterSpecification> exportFilters = dependency.getExportFilters();
                MultiplePathFilterBuilder importBuilder = PathFilters.multiplePathFilterBuilder((boolean)true);
                for (FilterSpecification filter : importFilters) {
                    importBuilder.addFilter(filter.getPathFilter(), filter.isInclude());
                }
                if (dependency.isImportServices()) {
                    importBuilder.addFilter(PathFilters.getMetaInfServicesFilter(), true);
                }
                importBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                importBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                PathFilter importFilter = importBuilder.create();
                if (exportFilters.isEmpty()) {
                    exportFilter = export ? PathFilters.acceptAll() : PathFilters.rejectAll();
                } else {
                    MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder((boolean)export);
                    for (FilterSpecification filter : exportFilters) {
                        exportBuilder.addFilter(filter.getPathFilter(), filter.isInclude());
                    }
                    exportFilter = exportBuilder.create();
                }
                DependencySpec depSpec = DependencySpec.createModuleDependencySpec((PathFilter)importFilter, (PathFilter)exportFilter, (ModuleLoader)dependency.getModuleLoader(), (ModuleIdentifier)dependency.getIdentifier(), (boolean)dependency.isOptional());
                specBuilder.addDependency(depSpec);
                logger.debugf("Adding dependency %s to module %s", dependency, specBuilder.getIdentifier());
            }
        }
    }

    private void addResourceRoot(ModuleSpec.Builder specBuilder, ResourceRoot resource, List<PermissionFactory> permFactories) throws DeploymentUnitProcessingException {
        try {
            VirtualFile root = resource.getRoot();
            if (resource.getExportFilters().isEmpty()) {
                specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)new VFSResourceLoader(resource.getRootName(), root, resource.isUsePhysicalCodeSource())));
            } else {
                MultiplePathFilterBuilder filterBuilder = PathFilters.multiplePathFilterBuilder((boolean)true);
                for (FilterSpecification filter : resource.getExportFilters()) {
                    filterBuilder.addFilter(filter.getPathFilter(), filter.isInclude());
                }
                specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)new VFSResourceLoader(resource.getRootName(), root, resource.isUsePhysicalCodeSource()), (PathFilter)filterBuilder.create()));
            }
            permFactories.add((PermissionFactory)new ImmediatePermissionFactory((Permission)new VirtualFilePermission(root.getPathName(), VirtualFilePermission.FLAG_READ)));
            permFactories.add((PermissionFactory)new ImmediatePermissionFactory((Permission)new VirtualFilePermission(root.getChild("-").getPathName(), VirtualFilePermission.FLAG_READ)));
        }
        catch (IOException e) {
            throw ServerLogger.ROOT_LOGGER.failedToCreateVFSResourceLoader(resource.getRootName(), e);
        }
    }

    static {
        Permissions permissions = new Permissions();
        permissions.add(new PropertyPermission("file.encoding", "read"));
        permissions.add(new PropertyPermission("file.separator", "read"));
        permissions.add(new PropertyPermission("java.class.version", "read"));
        permissions.add(new PropertyPermission("java.specification.version", "read"));
        permissions.add(new PropertyPermission("java.specification.vendor", "read"));
        permissions.add(new PropertyPermission("java.specification.name", "read"));
        permissions.add(new PropertyPermission("java.vendor", "read"));
        permissions.add(new PropertyPermission("java.vendor.url", "read"));
        permissions.add(new PropertyPermission("java.version", "read"));
        permissions.add(new PropertyPermission("java.vm.name", "read"));
        permissions.add(new PropertyPermission("java.vm.vendor", "read"));
        permissions.add(new PropertyPermission("java.vm.version", "read"));
        permissions.add(new PropertyPermission("line.separator", "read"));
        permissions.add(new PropertyPermission("os.name", "read"));
        permissions.add(new PropertyPermission("os.version", "read"));
        permissions.add(new PropertyPermission("os.arch", "read"));
        permissions.add(new PropertyPermission("path.separator", "read"));
        permissions.add(new PropertyPermission("java.runtime.name", "read"));
        permissions.add(new PropertyPermission("java.runtime.version", "read"));
        permissions.add(new PropertyPermission("java.vendor.url.bug", "read"));
        permissions.add(new PropertyPermission("java.vm.info", "read"));
        permissions.add(new PropertyPermission("java.vm.specification.name", "read"));
        permissions.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        permissions.add(new PropertyPermission("java.vm.specification.version", "read"));
        permissions.add(new PropertyPermission("sun.cpu.endian", "read"));
        permissions.add(new PropertyPermission("sun.cpu.isalist", "read"));
        permissions.add(new PropertyPermission("sun.management.compiler", "read"));
        permissions.setReadOnly();
        DEFAULT_PERMISSIONS = permissions;
    }

    private static final class ModuleDefinitionService
    implements org.jboss.msc.service.Service {
        private final Consumer<ModuleDefinition> moduleDefinitionConsumer;
        private final ModuleDefinition moduleDefinition;

        private ModuleDefinitionService(Consumer<ModuleDefinition> moduleDefinitionConsumer, ModuleDefinition moduleDefinition) {
            this.moduleDefinitionConsumer = moduleDefinitionConsumer;
            this.moduleDefinition = moduleDefinition;
        }

        public void start(StartContext startContext) {
            this.moduleDefinitionConsumer.accept(this.moduleDefinition);
        }

        public void stop(StopContext stopContext) {
            this.moduleDefinitionConsumer.accept(null);
        }

        public Object getValue() {
            return this.moduleDefinition;
        }
    }
}

