/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.resource.urlsegments;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.apache.wicket.util.parse.metapattern.OptionalMetaPattern;
import org.apache.wicket.util.parse.metapattern.parsers.VariableAssignmentParser;
import org.apache.wicket.util.string.StringValue;
import org.wicketstuff.rest.resource.urlsegments.FixedURLSegment;
import org.wicketstuff.rest.resource.urlsegments.MultiParamSegment;
import org.wicketstuff.rest.resource.urlsegments.ParamSegment;

public abstract class AbstractURLSegment
extends StringValue {
    public static final MetaPattern REGEXP_BODY = new MetaPattern("([^\\}\\{]*|(\\{[\\d]+\\}))*");
    public static final MetaPattern REGEXP_DECLARATION = new MetaPattern(new MetaPattern[]{MetaPattern.COLON, REGEXP_BODY});
    public static final MetaPattern SEGMENT_PARAMETER = new MetaPattern(new MetaPattern[]{MetaPattern.LEFT_CURLY, MetaPattern.VARIABLE_NAME, new OptionalMetaPattern(REGEXP_DECLARATION), MetaPattern.RIGHT_CURLY});
    private final MetaPattern metaPattern = this.loadMetaPattern();

    AbstractURLSegment(String text) {
        super(text);
    }

    protected abstract MetaPattern loadMetaPattern();

    public static AbstractURLSegment newSegment(String segment) {
        if (SEGMENT_PARAMETER.matcher((CharSequence)segment).matches()) {
            return new ParamSegment(segment);
        }
        if (SEGMENT_PARAMETER.matcher((CharSequence)segment).find()) {
            return new MultiParamSegment(segment);
        }
        return new FixedURLSegment(segment);
    }

    public abstract int calculateScore(String var1);

    public static String getActualSegment(String fullSegment) {
        String[] segmentParts = fullSegment.split(MetaPattern.SEMICOLON.toString());
        return segmentParts[0];
    }

    public static Map<String, String> getSegmentMatrixParameters(String fullSegment) {
        String[] segmentParts = fullSegment.split(MetaPattern.SEMICOLON.toString());
        HashMap<String, String> matrixParameters = new HashMap<String, String>();
        if (segmentParts.length < 2) {
            return matrixParameters;
        }
        for (int i = 1; i < segmentParts.length; ++i) {
            String parameterDeclar = segmentParts[i];
            VariableAssignmentParser parser = new VariableAssignmentParser((CharSequence)parameterDeclar);
            parser.matcher().find();
            matrixParameters.put(parser.getKey(), parser.getValue());
        }
        return matrixParameters;
    }

    public abstract void populatePathVariables(Map<String, String> var1, String var2);

    public final MetaPattern getMetaPattern() {
        return this.metaPattern;
    }
}

