/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.comparator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.unitils.reflectionassert.ReflectionComparator;
import org.unitils.reflectionassert.comparator.Comparator;
import org.unitils.reflectionassert.difference.CollectionDifference;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.util.CollectionUtils;

public class CollectionComparator
implements Comparator {
    @Override
    public boolean canCompare(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        return !(!left.getClass().isArray() && !(left instanceof Collection) || !right.getClass().isArray() && !(right instanceof Collection));
    }

    @Override
    public Difference compare(Object left, Object right, boolean onlyFirstDifference, ReflectionComparator reflectionComparator) {
        ArrayList leftList = new ArrayList(CollectionUtils.convertToCollection(left));
        ArrayList rightList = new ArrayList(CollectionUtils.convertToCollection(right));
        int elementIndex = -1;
        CollectionDifference difference = new CollectionDifference("Different elements", left, right, leftList, rightList);
        Iterator leftIterator = leftList.iterator();
        Iterator rightIterator = rightList.iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            ++elementIndex;
            Difference elementDifference = reflectionComparator.getDifference(leftIterator.next(), rightIterator.next(), onlyFirstDifference);
            if (elementDifference == null) continue;
            difference.addElementDifference(elementIndex, elementDifference);
            if (!onlyFirstDifference) continue;
            return difference;
        }
        int leftElementIndex = elementIndex;
        while (leftIterator.hasNext()) {
            leftIterator.next();
            difference.addLeftMissingIndex(++leftElementIndex);
        }
        int rightElementIndex = elementIndex;
        while (rightIterator.hasNext()) {
            rightIterator.next();
            difference.addRightMissingIndex(++rightElementIndex);
        }
        if (difference.getElementDifferences().isEmpty() && difference.getLeftMissingIndexes().isEmpty() && difference.getRightMissingIndexes().isEmpty()) {
            return null;
        }
        return difference;
    }
}

