/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.core.util.Configurable;
import org.unitils.util.ReflectionUtils;

public class UnitilsConfiguration {
    private static Log logger = LogFactory.getLog(UnitilsConfiguration.class);
    private Properties properties;

    public UnitilsConfiguration(Properties properties) {
        this.properties = properties;
    }

    public String getString(String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            throw new UnitilsException("No value found for property " + propertyName);
        }
        return value.trim();
    }

    public String getString(String propertyName, String defaultValue) {
        String value = this.properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return value.trim();
    }

    public List<String> getStringList(String propertyName) {
        return this.getStringList(propertyName, false);
    }

    public List<String> getStringList(String propertyName, boolean required) {
        String values = this.properties.getProperty(propertyName);
        if (values == null || "".equals(values.trim())) {
            if (required) {
                throw new UnitilsException("No value found for property " + propertyName);
            }
            return new ArrayList<String>(0);
        }
        String[] splitValues = values.split(",");
        ArrayList<String> result = new ArrayList<String>(splitValues.length);
        for (String value : splitValues) {
            if (value == null || "".equals(value.trim())) continue;
            result.add(value.trim());
        }
        if (required && result.isEmpty()) {
            throw new UnitilsException("No value found for property " + propertyName);
        }
        return result;
    }

    public boolean getBoolean(String propertyName) {
        String value = this.getString(propertyName, null);
        if (value == null || "".equals(value.trim())) {
            throw new UnitilsException("No value found for property " + propertyName);
        }
        return this.toBoolean(propertyName, value);
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        String value = this.getString(propertyName, null);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return this.toBoolean(propertyName, value);
    }

    private boolean toBoolean(String propertyName, String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new UnitilsException("Value " + value + " for property " + propertyName + " is not a boolean.");
    }

    public long getLong(String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            throw new UnitilsException("No value found for property " + propertyName);
        }
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new UnitilsException("Value " + value + " for property " + propertyName + " is not a long.");
        }
    }

    public long getLong(String propertyName, long defaultValue) {
        String value = this.properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new UnitilsException("Value " + value + " for property " + propertyName + " is not a long.");
        }
    }

    public int getInt(String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            throw new UnitilsException("No value found for property " + propertyName);
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new UnitilsException("Value " + value + " for property " + propertyName + " is not a number.");
        }
    }

    public int getInt(String propertyName, int defaultValue) {
        String value = this.properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new UnitilsException("Value " + value + " for property " + propertyName + " is not a number.");
        }
    }

    public <T> T getInstance(String propertyName) {
        String className = this.getString(propertyName);
        return ReflectionUtils.createInstanceOfType(className, false);
    }

    public <T> T getInstance(String propertyName, T defaultValue) {
        String className = this.getString(propertyName, null);
        if (className == null) {
            return defaultValue;
        }
        return this.createInstance(className);
    }

    public <T> T getInstanceOf(Class<T> type, String ... discriminators) {
        String implClassName = this.getImplClassName(type, discriminators);
        logger.debug((Object)("Creating instance of " + type + ". Implementation class " + implClassName));
        return this.createInstance(implClassName);
    }

    private String getImplClassName(Class<?> type, String ... discriminators) {
        String className = null;
        String propertyName = type.getName() + ".implClassName";
        if (discriminators != null) {
            StringBuffer propertyNameWithDiscriminators = new StringBuffer(propertyName);
            for (String discriminator : discriminators) {
                propertyNameWithDiscriminators.append('.');
                propertyNameWithDiscriminators.append(discriminator);
                String classNameForDiscriminator = this.getString(propertyNameWithDiscriminators.toString(), null);
                if (classNameForDiscriminator == null) continue;
                className = classNameForDiscriminator;
            }
        }
        if (className == null) {
            className = this.getString(propertyName);
        }
        return className;
    }

    private <T> T createInstance(String className) {
        Object instance = ReflectionUtils.createInstanceOfType(className, false);
        if (instance instanceof Configurable) {
            ((Configurable)instance).init(this.properties);
        }
        return instance;
    }

    public boolean containsProperty(String propertyName) {
        return this.properties.getProperty(propertyName) != null;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

