/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.comparator.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.unitils.reflectionassert.ReflectionComparator;
import org.unitils.reflectionassert.comparator.Comparator;
import org.unitils.reflectionassert.difference.ClassDifference;
import org.unitils.reflectionassert.difference.Difference;
import org.unitils.reflectionassert.difference.ObjectDifference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectComparator
implements Comparator {
    @Override
    public boolean canCompare(Object left, Object right) {
        return left != null && right != null;
    }

    @Override
    public Difference compare(Object left, Object right, boolean onlyFirstDifference, ReflectionComparator reflectionComparator) {
        Class<?> clazz = left.getClass();
        if (!clazz.isAssignableFrom(right.getClass())) {
            return new ClassDifference("Different classes. Left: " + clazz + ", right: " + right.getClass(), left, right, left.getClass(), right.getClass());
        }
        ObjectDifference difference = new ObjectDifference("Different field values", left, right);
        this.compareFields(left, right, clazz, difference, onlyFirstDifference, reflectionComparator);
        if (difference.getFieldDifferences().isEmpty()) {
            return null;
        }
        return difference;
    }

    protected void compareFields(Object left, Object right, Class<?> clazz, ObjectDifference difference, boolean onlyFirstDifference, ReflectionComparator reflectionComparator) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            if (Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers()) || ((Field)field).isSynthetic()) continue;
            try {
                Difference innerDifference = reflectionComparator.getDifference(((Field)field).get(left), ((Field)field).get(right), onlyFirstDifference);
                if (innerDifference == null) continue;
                difference.addFieldDifference(((Field)field).getName(), innerDifference);
                if (!onlyFirstDifference) continue;
                return;
            }
            catch (IllegalAccessException e) {
                throw new InternalError("Unexpected IllegalAccessException");
            }
        }
        for (Class<?> superclazz = clazz.getSuperclass(); superclazz != null && !superclazz.getName().startsWith("java.lang"); superclazz = superclazz.getSuperclass()) {
            this.compareFields(left, right, superclazz, difference, onlyFirstDifference, reflectionComparator);
        }
    }
}

