/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services.impl;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.apache.tapestry5.ioc.services.PipelineBuilder;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.HttpServletRequestHandler;
import org.slf4j.Logger;
import org.tynamo.security.services.impl.HttpServletRequestFilterWrapper;
import org.tynamo.security.shiro.AccessControlFilter;

public class SecurityFilterChain {
    private String path;
    private HttpServletRequestHandler handler;

    public SecurityFilterChain(String path, HttpServletRequestHandler handler) {
        this.path = path;
        this.handler = handler;
    }

    public HttpServletRequestHandler getHandler() {
        return this.handler;
    }

    public String getPath() {
        return this.path;
    }

    public static class Builder {
        PipelineBuilder pipelineBuilder;
        String path;
        private List<HttpServletRequestFilter> filters = new ArrayList<HttpServletRequestFilter>();
        private Logger logger;

        public Builder(Logger logger, PipelineBuilder pipelineBuilder, String path) {
            this.logger = logger;
            this.pipelineBuilder = pipelineBuilder;
            this.path = path;
        }

        public Builder add(Class<HttpServletRequestFilter> filterType) {
            try {
                this.filters.add(filterType.newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Couldn't instantiate a filter while building a security chain for path '" + this.path + "': ", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Couldn't instantiate a filter while building a security chain for path '" + this.path + "': ", e);
            }
            return this;
        }

        public Builder add(Filter filter) {
            if (filter instanceof AccessControlFilter) {
                this.add((AccessControlFilter)filter, null);
            } else {
                this.filters.add(new HttpServletRequestFilterWrapper(filter));
            }
            return this;
        }

        public Builder add(AccessControlFilter filter, String config) {
            filter.addConfig(config);
            this.filters.add(new HttpServletRequestFilterWrapper((Filter)filter));
            return this;
        }

        public SecurityFilterChain build() {
            return new SecurityFilterChain(this.path, (HttpServletRequestHandler)this.pipelineBuilder.build(this.logger, HttpServletRequestHandler.class, HttpServletRequestFilter.class, this.filters));
        }
    }
}

