/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Objects;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.TwitterObjectFactory;
import twitter4j.v1.Trend;

final class TrendJSONImpl
implements Trend,
Serializable {
    private static final long serialVersionUID = -4353426776065521132L;
    private final String name;
    private final String url;
    private final String query;
    private final int tweetVolume;

    TrendJSONImpl(JSONObject json, boolean storeJSON) {
        this.name = ParseUtil.getRawString("name", json);
        this.url = ParseUtil.getRawString("url", json);
        this.query = ParseUtil.getRawString("query", json);
        this.tweetVolume = ParseUtil.getInt("tweet_volume", json);
        if (storeJSON) {
            TwitterObjectFactory.registerJSONObject(this, json);
        }
    }

    TrendJSONImpl(JSONObject json) {
        this(json, false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public int getTweetVolume() {
        return this.tweetVolume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrendJSONImpl trendJSON = (TrendJSONImpl)o;
        return this.tweetVolume == trendJSON.tweetVolume && Objects.equals(this.name, trendJSON.name) && Objects.equals(this.url, trendJSON.url) && Objects.equals(this.query, trendJSON.query);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        result = 31 * result + this.tweetVolume;
        return result;
    }

    public String toString() {
        return "TrendJSONImpl{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", query='" + this.query + '\'' + ", tweet_volume=" + this.tweetVolume + '}';
    }
}

