/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.file;

import tachyon.client.ClientContext;
import tachyon.client.FileSystemMasterClient;
import tachyon.client.block.TachyonBlockStore;
import tachyon.client.file.FileSystemMasterClientPool;

public enum FileSystemContext {
    INSTANCE;

    private FileSystemMasterClientPool mFileSystemMasterClientPool = new FileSystemMasterClientPool(ClientContext.getMasterAddress());
    private final TachyonBlockStore mTachyonBlockStore = TachyonBlockStore.get();

    public FileSystemMasterClient acquireMasterClient() {
        return (FileSystemMasterClient)this.mFileSystemMasterClientPool.acquire();
    }

    public void releaseMasterClient(FileSystemMasterClient masterClient) {
        this.mFileSystemMasterClientPool.release(masterClient);
    }

    public synchronized TachyonBlockStore getTachyonBlockStore() {
        return this.mTachyonBlockStore;
    }

    public synchronized void reset() {
        this.mFileSystemMasterClientPool.close();
        this.mFileSystemMasterClientPool = new FileSystemMasterClientPool(ClientContext.getMasterAddress());
    }
}

