/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.block;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import tachyon.client.BlockMasterClient;
import tachyon.client.ClientContext;
import tachyon.client.block.BlockMasterClientPool;
import tachyon.client.block.BlockWorkerClientPool;
import tachyon.thrift.NetAddress;
import tachyon.thrift.WorkerInfo;
import tachyon.util.network.NetworkAddressUtils;
import tachyon.worker.ClientMetrics;
import tachyon.worker.WorkerClient;

public enum BlockStoreContext {
    INSTANCE;

    private BlockMasterClientPool mBlockMasterClientPool;
    private BlockWorkerClientPool mLocalBlockWorkerClientPool;
    private boolean mLocalBlockWorkerClientPoolInitialized;

    private BlockStoreContext() {
        this.reset();
    }

    private synchronized void initializeLocalBlockWorkerClientPool() {
        NetAddress localWorkerAddress = this.getWorkerAddress(NetworkAddressUtils.getLocalHostName(ClientContext.getConf()));
        this.mLocalBlockWorkerClientPool = localWorkerAddress == null ? null : new BlockWorkerClientPool(localWorkerAddress);
        this.mLocalBlockWorkerClientPoolInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized NetAddress getWorkerAddress(String hostname) {
        BlockMasterClient masterClient = this.acquireMasterClient();
        try {
            List<WorkerInfo> workers = masterClient.getWorkerInfoList();
            if (hostname.isEmpty() && !workers.isEmpty()) {
                NetAddress netAddress = workers.get(0).getAddress();
                return netAddress;
            }
            for (WorkerInfo worker : workers) {
                if (!worker.getAddress().getHost().equals(hostname)) continue;
                NetAddress netAddress = worker.getAddress();
                return netAddress;
            }
        }
        catch (IOException ioe) {
            Throwables.propagate((Throwable)ioe);
        }
        finally {
            this.releaseMasterClient(masterClient);
        }
        return null;
    }

    public BlockMasterClient acquireMasterClient() {
        return (BlockMasterClient)this.mBlockMasterClientPool.acquire();
    }

    public void releaseMasterClient(BlockMasterClient masterClient) {
        this.mBlockMasterClientPool.release(masterClient);
    }

    public synchronized WorkerClient acquireWorkerClient() {
        WorkerClient client = this.acquireLocalWorkerClient();
        if (client == null) {
            return this.acquireRemoteWorkerClient("");
        }
        return client;
    }

    public synchronized WorkerClient acquireWorkerClient(String hostname) throws IOException {
        WorkerClient client;
        if (hostname.equals(NetworkAddressUtils.getLocalHostName(ClientContext.getConf()))) {
            client = this.acquireLocalWorkerClient();
            if (client == null) {
                throw new IOException("No Tachyon worker available for host: " + hostname);
            }
        } else {
            client = this.acquireRemoteWorkerClient(hostname);
        }
        return client;
    }

    public synchronized WorkerClient acquireLocalWorkerClient() {
        if (!this.mLocalBlockWorkerClientPoolInitialized) {
            this.initializeLocalBlockWorkerClientPool();
        }
        if (this.mLocalBlockWorkerClientPool == null) {
            return null;
        }
        return (WorkerClient)this.mLocalBlockWorkerClientPool.acquire();
    }

    private synchronized WorkerClient acquireRemoteWorkerClient(String hostname) {
        Preconditions.checkArgument((!hostname.equals(NetworkAddressUtils.getLocalHostName(ClientContext.getConf())) ? 1 : 0) != 0, (Object)"Acquire Remote Worker Client cannot not be called with local hostname");
        NetAddress workerAddress = this.getWorkerAddress(hostname);
        if (workerAddress == null) {
            throw new RuntimeException("No Tachyon worker available for host: " + hostname);
        }
        long clientId = ClientContext.getRandomNonNegativeLong();
        return new WorkerClient(workerAddress, ClientContext.getExecutorService(), ClientContext.getConf(), clientId, false, new ClientMetrics());
    }

    public void releaseWorkerClient(WorkerClient workerClient) {
        if (workerClient.isLocal()) {
            Preconditions.checkState((this.mLocalBlockWorkerClientPool != null ? 1 : 0) != 0);
            this.mLocalBlockWorkerClientPool.release(workerClient);
        } else {
            workerClient.close();
        }
    }

    public synchronized boolean hasLocalWorker() {
        if (!this.mLocalBlockWorkerClientPoolInitialized) {
            this.initializeLocalBlockWorkerClientPool();
        }
        return this.mLocalBlockWorkerClientPool != null;
    }

    public synchronized void reset() {
        if (this.mBlockMasterClientPool != null) {
            this.mBlockMasterClientPool.close();
        }
        if (this.mLocalBlockWorkerClientPool != null) {
            this.mLocalBlockWorkerClientPool.close();
        }
        this.mBlockMasterClientPool = new BlockMasterClientPool(ClientContext.getMasterAddress());
        this.mLocalBlockWorkerClientPoolInitialized = false;
    }
}

