/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.JpaAccessor;
import org.springframework.orm.jpa.JpaCallback;
import org.springframework.orm.jpa.JpaOperations;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaTemplate
extends JpaAccessor
implements JpaOperations {
    private boolean exposeNativeEntityManager = false;

    public JpaTemplate() {
    }

    public JpaTemplate(EntityManagerFactory emf) {
        this.setEntityManagerFactory(emf);
        this.afterPropertiesSet();
    }

    public JpaTemplate(EntityManager em) {
        this.setEntityManager(em);
        this.afterPropertiesSet();
    }

    public void setExposeNativeEntityManager(boolean exposeNativeEntityManager) {
        this.exposeNativeEntityManager = exposeNativeEntityManager;
    }

    public boolean isExposeNativeEntityManager() {
        return this.exposeNativeEntityManager;
    }

    @Override
    public Object execute(JpaCallback action) throws DataAccessException {
        return this.execute(action, this.isExposeNativeEntityManager());
    }

    @Override
    public List executeFind(JpaCallback action) throws DataAccessException {
        Object result = this.execute(action, this.isExposeNativeEntityManager());
        if (!(result instanceof List)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from JpaCallback isn't a List: [" + result + "]");
        }
        return (List)result;
    }

    public Object execute(JpaCallback action, boolean exposeNativeEntityManager) throws DataAccessException {
        Assert.notNull(action, "Callback object must not be null");
        EntityManager em = this.getEntityManager();
        boolean isNewEm = false;
        if (em == null && (em = this.getTransactionalEntityManager()) == null) {
            this.logger.debug((Object)"Creating new EntityManager for JpaTemplate execution");
            em = this.createEntityManager();
            isNewEm = true;
        }
        try {
            EntityManager emToExpose = exposeNativeEntityManager ? em : this.createEntityManagerProxy(em);
            Object result = action.doInJpa(emToExpose);
            this.flushIfNecessary(em, !isNewEm);
            Object object = result;
            return object;
        }
        catch (RuntimeException ex) {
            throw this.translateIfNecessary(ex);
        }
        finally {
            if (isNewEm) {
                this.logger.debug((Object)"Closing new EntityManager after JPA template execution");
                EntityManagerFactoryUtils.closeEntityManager(em);
            }
        }
    }

    protected EntityManager createEntityManagerProxy(EntityManager em) {
        Class<? extends EntityManager> entityManagerInterface;
        Class[] ifcs = null;
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf instanceof EntityManagerFactoryInfo && (entityManagerInterface = ((EntityManagerFactoryInfo)emf).getEntityManagerInterface()) != null) {
            ifcs = new Class[]{entityManagerInterface};
        }
        if (ifcs == null) {
            ifcs = ClassUtils.getAllInterfacesForClass(em.getClass());
        }
        return (EntityManager)Proxy.newProxyInstance(em.getClass().getClassLoader(), ifcs, (InvocationHandler)new CloseSuppressingInvocationHandler(em));
    }

    @Override
    public <T> T find(final Class<T> entityClass, final Object id) throws DataAccessException {
        return (T)this.execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                return em.find(entityClass, id);
            }
        }, true);
    }

    @Override
    public <T> T getReference(final Class<T> entityClass, final Object id) throws DataAccessException {
        return (T)this.execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                return em.getReference(entityClass, id);
            }
        }, true);
    }

    @Override
    public boolean contains(final Object entity) throws DataAccessException {
        Boolean result = (Boolean)this.execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                return new Boolean(em.contains(entity));
            }
        }, true);
        return result;
    }

    @Override
    public void refresh(final Object entity) throws DataAccessException {
        this.execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                em.refresh(entity);
                return null;
            }
        }, true);
    }

    @Override
    public void persist(final Object entity) throws DataAccessException {
        this.execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                em.persist(entity);
                return null;
            }
        }, true);
    }

    @Override
    public <T> T merge(final T entity) throws DataAccessException {
        return (T)this.execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                return em.merge(entity);
            }
        }, true);
    }

    @Override
    public void remove(final Object entity) throws DataAccessException {
        this.execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                em.remove(entity);
                return null;
            }
        }, true);
    }

    @Override
    public void flush() throws DataAccessException {
        this.execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                em.flush();
                return null;
            }
        }, true);
    }

    @Override
    public List find(String queryString) throws DataAccessException {
        return this.find(queryString, (Object[])null);
    }

    @Override
    public List find(final String queryString, final Object ... values) throws DataAccessException {
        return this.executeFind(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Query queryObject = em.createQuery(queryString);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i + 1, values[i]);
                    }
                }
                return queryObject.getResultList();
            }
        });
    }

    public List findByNamedParams(final String queryString, final Map<String, ?> params) throws DataAccessException {
        return this.executeFind(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Query queryObject = em.createQuery(queryString);
                if (params != null) {
                    for (Map.Entry entry : params.entrySet()) {
                        queryObject.setParameter((String)entry.getKey(), entry.getValue());
                    }
                }
                return queryObject.getResultList();
            }
        });
    }

    @Override
    public List findByNamedQuery(String queryName) throws DataAccessException {
        return this.findByNamedQuery(queryName, null);
    }

    @Override
    public List findByNamedQuery(final String queryName, final Object ... values) throws DataAccessException {
        return this.executeFind(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Query queryObject = em.createNamedQuery(queryName);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i + 1, values[i]);
                    }
                }
                return queryObject.getResultList();
            }
        });
    }

    public List findByNamedQueryAndNamedParams(final String queryName, final Map<String, ?> params) throws DataAccessException {
        return this.executeFind(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Query queryObject = em.createNamedQuery(queryName);
                if (params != null) {
                    for (Map.Entry entry : params.entrySet()) {
                        queryObject.setParameter((String)entry.getKey(), entry.getValue());
                    }
                }
                return queryObject.getResultList();
            }
        });
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final EntityManager target;

        public CloseSuppressingInvocationHandler(EntityManager target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

