/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.messaging.simp.broker.SimpleBrokerMessageHandler;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.messaging.simp.user.DefaultUserDestinationResolver;
import org.springframework.messaging.simp.user.DefaultUserSessionRegistry;
import org.springframework.messaging.simp.user.UserDestinationMessageHandler;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.socket.config.WebSocketNamespaceUtils;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;
import org.springframework.web.socket.sockjs.support.SockJsHttpRequestHandler;
import org.w3c.dom.Element;

class MessageBrokerBeanDefinitionParser
implements BeanDefinitionParser {
    protected static final String SOCKJS_SCHEDULER_BEAN_NAME = "messageBrokerSockJsScheduler";
    private static final int DEFAULT_MAPPING_ORDER = 1;
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)MessageBrokerBeanDefinitionParser.class.getClassLoader());

    MessageBrokerBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserCxt) {
        Object source = parserCxt.extractSource((Object)element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserCxt.pushContainingComponent(compDefinition);
        String orderAttribute = element.getAttribute("order");
        int order = orderAttribute.isEmpty() ? 1 : Integer.valueOf(orderAttribute);
        ManagedMap urlMap = new ManagedMap();
        urlMap.setSource(source);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDef.getPropertyValues().add("order", (Object)order);
        handlerMappingDef.getPropertyValues().add("urlMap", (Object)urlMap);
        String beanName = "clientInboundChannel";
        Element channelElem = DomUtils.getChildElementByTagName((Element)element, (String)"client-inbound-channel");
        RuntimeBeanReference clientInChannel = this.getMessageChannel(beanName, channelElem, parserCxt, source);
        beanName = "clientOutboundChannel";
        channelElem = DomUtils.getChildElementByTagName((Element)element, (String)"client-outbound-channel");
        RuntimeBeanReference clientOutChannel = this.getMessageChannel(beanName, channelElem, parserCxt, source);
        RootBeanDefinition beanDef = new RootBeanDefinition(DefaultUserSessionRegistry.class);
        beanName = MessageBrokerBeanDefinitionParser.registerBeanDef(beanDef, parserCxt, source);
        RuntimeBeanReference userSessionRegistry = new RuntimeBeanReference(beanName);
        RuntimeBeanReference subProtocolWsHandler = this.registerSubProtocolWebSocketHandler(element, clientInChannel, clientOutChannel, userSessionRegistry, parserCxt, source);
        for (Element stompEndpointElem : DomUtils.getChildElementsByTagName((Element)element, (String)"stomp-endpoint")) {
            RuntimeBeanReference httpRequestHandler = this.registerHttpRequestHandler(stompEndpointElem, subProtocolWsHandler, parserCxt, source);
            String pathAttribute = stompEndpointElem.getAttribute("path");
            Assert.state((boolean)StringUtils.hasText((String)pathAttribute), (String)"Invalid <stomp-endpoint> (no path mapping)");
            List<String> paths = Arrays.asList(StringUtils.tokenizeToStringArray((String)pathAttribute, (String)","));
            for (String path : paths) {
                path = path.trim();
                Assert.state((boolean)StringUtils.hasText((String)path), (String)("Invalid <stomp-endpoint> path attribute: " + pathAttribute));
                if (DomUtils.getChildElementByTagName((Element)stompEndpointElem, (String)"sockjs") != null) {
                    path = path.endsWith("/") ? path + "**" : path + "/**";
                }
                urlMap.put((Object)path, (Object)httpRequestHandler);
            }
        }
        MessageBrokerBeanDefinitionParser.registerBeanDef(handlerMappingDef, parserCxt, source);
        beanName = "brokerChannel";
        channelElem = DomUtils.getChildElementByTagName((Element)element, (String)"broker-channel");
        RuntimeBeanReference brokerChannel = this.getMessageChannel(beanName, channelElem, parserCxt, source);
        this.registerMessageBroker(element, clientInChannel, clientOutChannel, brokerChannel, parserCxt, source);
        RuntimeBeanReference messageConverter = this.registerBrokerMessageConverter(element, parserCxt, source);
        RuntimeBeanReference messagingTemplate = this.registerBrokerMessagingTemplate(element, brokerChannel, messageConverter, parserCxt, source);
        this.registerAnnotationMethodMessageHandler(element, clientInChannel, clientOutChannel, messageConverter, messagingTemplate, parserCxt, source);
        RuntimeBeanReference userDestinationResolver = this.registerUserDestinationResolver(element, userSessionRegistry, parserCxt, source);
        this.registerUserDestinationMessageHandler(clientInChannel, clientOutChannel, brokerChannel, userDestinationResolver, parserCxt, source);
        parserCxt.popAndRegisterContainingComponent();
        return null;
    }

    private RuntimeBeanReference getMessageChannel(String channelName, Element channelElement, ParserContext parserCxt, Object source) {
        RootBeanDefinition executorDef = null;
        if (channelElement == null) {
            executorDef = this.getDefaultExecutorBeanDefinition(channelName);
        } else {
            Element executor = DomUtils.getChildElementByTagName((Element)channelElement, (String)"executor");
            if (executor == null) {
                executorDef = this.getDefaultExecutorBeanDefinition(channelName);
            } else {
                executorDef = new RootBeanDefinition(ThreadPoolTaskExecutor.class);
                String attrValue = executor.getAttribute("core-pool-size");
                if (!StringUtils.isEmpty((Object)attrValue)) {
                    executorDef.getPropertyValues().add("corePoolSize", (Object)attrValue);
                }
                if (!StringUtils.isEmpty((Object)(attrValue = executor.getAttribute("max-pool-size")))) {
                    executorDef.getPropertyValues().add("maxPoolSize", (Object)attrValue);
                }
                if (!StringUtils.isEmpty((Object)(attrValue = executor.getAttribute("keep-alive-seconds")))) {
                    executorDef.getPropertyValues().add("keepAliveSeconds", (Object)attrValue);
                }
                if (!StringUtils.isEmpty((Object)(attrValue = executor.getAttribute("queue-capacity")))) {
                    executorDef.getPropertyValues().add("queueCapacity", (Object)attrValue);
                }
            }
        }
        ConstructorArgumentValues argValues = new ConstructorArgumentValues();
        if (executorDef != null) {
            executorDef.getPropertyValues().add("threadNamePrefix", (Object)(channelName + "-"));
            String executorName = channelName + "Executor";
            MessageBrokerBeanDefinitionParser.registerBeanDefByName(executorName, executorDef, parserCxt, source);
            argValues.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(executorName));
        }
        RootBeanDefinition channelDef = new RootBeanDefinition(ExecutorSubscribableChannel.class, argValues, null);
        if (channelElement != null) {
            Element interceptorsElement = DomUtils.getChildElementByTagName((Element)channelElement, (String)"interceptors");
            ManagedList<? super Object> interceptorList = WebSocketNamespaceUtils.parseBeanSubElements(interceptorsElement, parserCxt);
            channelDef.getPropertyValues().add("interceptors", interceptorList);
        }
        MessageBrokerBeanDefinitionParser.registerBeanDefByName(channelName, channelDef, parserCxt, source);
        return new RuntimeBeanReference(channelName);
    }

    private RootBeanDefinition getDefaultExecutorBeanDefinition(String channelName) {
        if (channelName.equals("brokerChannel")) {
            return null;
        }
        RootBeanDefinition executorDef = new RootBeanDefinition(ThreadPoolTaskExecutor.class);
        executorDef.getPropertyValues().add("corePoolSize", (Object)(Runtime.getRuntime().availableProcessors() * 2));
        executorDef.getPropertyValues().add("maxPoolSize", (Object)Integer.MAX_VALUE);
        executorDef.getPropertyValues().add("queueCapacity", (Object)Integer.MAX_VALUE);
        return executorDef;
    }

    private RuntimeBeanReference registerSubProtocolWebSocketHandler(Element element, RuntimeBeanReference clientInChannel, RuntimeBeanReference clientOutChannel, RuntimeBeanReference userSessionRegistry, ParserContext parserCxt, Object source) {
        RootBeanDefinition stompHandlerDef = new RootBeanDefinition(StompSubProtocolHandler.class);
        stompHandlerDef.getPropertyValues().add("userSessionRegistry", (Object)userSessionRegistry);
        MessageBrokerBeanDefinitionParser.registerBeanDef(stompHandlerDef, parserCxt, source);
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)clientInChannel);
        cavs.addIndexedArgumentValue(1, (Object)clientOutChannel);
        RootBeanDefinition subProtocolWshDef = new RootBeanDefinition(SubProtocolWebSocketHandler.class, cavs, null);
        subProtocolWshDef.getPropertyValues().addPropertyValue("protocolHandlers", (Object)stompHandlerDef);
        String subProtocolWshName = MessageBrokerBeanDefinitionParser.registerBeanDef(subProtocolWshDef, parserCxt, source);
        Element transportElem = DomUtils.getChildElementByTagName((Element)element, (String)"transport");
        if (transportElem != null) {
            String sendBufferSizeLimit;
            String sendTimeLimit;
            String messageSize = transportElem.getAttribute("message-size");
            if (messageSize != null) {
                stompHandlerDef.getPropertyValues().add("messageSizeLimit", (Object)messageSize);
            }
            if ((sendTimeLimit = transportElem.getAttribute("send-timeout")) != null) {
                subProtocolWshDef.getPropertyValues().add("sendTimeLimit", (Object)sendTimeLimit);
            }
            if ((sendBufferSizeLimit = transportElem.getAttribute("send-buffer-size")) != null) {
                subProtocolWshDef.getPropertyValues().add("sendBufferSizeLimit", (Object)sendBufferSizeLimit);
            }
        }
        return new RuntimeBeanReference(subProtocolWshName);
    }

    private RuntimeBeanReference registerHttpRequestHandler(Element stompEndpointElement, RuntimeBeanReference subProtocolWebSocketHandler, ParserContext parserCxt, Object source) {
        RootBeanDefinition httpRequestHandlerDef;
        RuntimeBeanReference sockJsService = WebSocketNamespaceUtils.registerSockJsService(stompEndpointElement, SOCKJS_SCHEDULER_BEAN_NAME, parserCxt, source);
        if (sockJsService != null) {
            ConstructorArgumentValues cavs = new ConstructorArgumentValues();
            cavs.addIndexedArgumentValue(0, (Object)sockJsService);
            cavs.addIndexedArgumentValue(1, (Object)subProtocolWebSocketHandler);
            httpRequestHandlerDef = new RootBeanDefinition(SockJsHttpRequestHandler.class, cavs, null);
        } else {
            RuntimeBeanReference handshakeHandler = WebSocketNamespaceUtils.registerHandshakeHandler(stompEndpointElement, parserCxt, source);
            ConstructorArgumentValues cavs = new ConstructorArgumentValues();
            cavs.addIndexedArgumentValue(0, (Object)subProtocolWebSocketHandler);
            if (handshakeHandler != null) {
                cavs.addIndexedArgumentValue(1, (Object)handshakeHandler);
            }
            httpRequestHandlerDef = new RootBeanDefinition(WebSocketHttpRequestHandler.class, cavs, null);
        }
        String httpRequestHandlerBeanName = MessageBrokerBeanDefinitionParser.registerBeanDef(httpRequestHandlerDef, parserCxt, source);
        return new RuntimeBeanReference(httpRequestHandlerBeanName);
    }

    private void registerMessageBroker(Element messageBrokerElement, RuntimeBeanReference clientInChannelDef, RuntimeBeanReference clientOutChannelDef, RuntimeBeanReference brokerChannelDef, ParserContext parserCxt, Object source) {
        Element simpleBrokerElem = DomUtils.getChildElementByTagName((Element)messageBrokerElement, (String)"simple-broker");
        Element brokerRelayElem = DomUtils.getChildElementByTagName((Element)messageBrokerElement, (String)"stomp-broker-relay");
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)clientInChannelDef);
        cavs.addIndexedArgumentValue(1, (Object)clientOutChannelDef);
        cavs.addIndexedArgumentValue(2, (Object)brokerChannelDef);
        if (simpleBrokerElem != null) {
            String prefix = simpleBrokerElem.getAttribute("prefix");
            cavs.addIndexedArgumentValue(3, Arrays.asList(StringUtils.tokenizeToStringArray((String)prefix, (String)",")));
            RootBeanDefinition brokerDef = new RootBeanDefinition(SimpleBrokerMessageHandler.class, cavs, null);
            MessageBrokerBeanDefinitionParser.registerBeanDef(brokerDef, parserCxt, source);
        } else if (brokerRelayElem != null) {
            String attrValue;
            String relayPort;
            String prefix = brokerRelayElem.getAttribute("prefix");
            cavs.addIndexedArgumentValue(3, Arrays.asList(StringUtils.tokenizeToStringArray((String)prefix, (String)",")));
            MutablePropertyValues mpvs = new MutablePropertyValues();
            String relayHost = brokerRelayElem.getAttribute("relay-host");
            if (!relayHost.isEmpty()) {
                mpvs.add("relayHost", (Object)relayHost);
            }
            if (!(relayPort = brokerRelayElem.getAttribute("relay-port")).isEmpty()) {
                mpvs.add("relayPort", (Object)Integer.valueOf(relayPort));
            }
            if (!(attrValue = brokerRelayElem.getAttribute("client-login")).isEmpty()) {
                mpvs.add("clientLogin", (Object)attrValue);
            }
            if (!(attrValue = brokerRelayElem.getAttribute("client-passcode")).isEmpty()) {
                mpvs.add("clientPasscode", (Object)attrValue);
            }
            if (!(attrValue = brokerRelayElem.getAttribute("system-login")).isEmpty()) {
                mpvs.add("systemLogin", (Object)attrValue);
            }
            if (!(attrValue = brokerRelayElem.getAttribute("system-passcode")).isEmpty()) {
                mpvs.add("systemPasscode", (Object)attrValue);
            }
            if (!(attrValue = brokerRelayElem.getAttribute("heartbeat-send-interval")).isEmpty()) {
                mpvs.add("systemHeartbeatSendInterval", (Object)Long.parseLong(attrValue));
            }
            if (!(attrValue = brokerRelayElem.getAttribute("heartbeat-receive-interval")).isEmpty()) {
                mpvs.add("systemHeartbeatReceiveInterval", (Object)Long.parseLong(attrValue));
            }
            if (!(attrValue = brokerRelayElem.getAttribute("virtual-host")).isEmpty()) {
                mpvs.add("virtualHost", (Object)attrValue);
            }
            Class<StompBrokerRelayMessageHandler> handlerType = StompBrokerRelayMessageHandler.class;
            RootBeanDefinition messageBrokerDef = new RootBeanDefinition(handlerType, cavs, mpvs);
            MessageBrokerBeanDefinitionParser.registerBeanDef(messageBrokerDef, parserCxt, source);
        }
    }

    private RuntimeBeanReference registerBrokerMessageConverter(Element element, ParserContext parserCxt, Object source) {
        Element convertersElement = DomUtils.getChildElementByTagName((Element)element, (String)"message-converters");
        ManagedList convertersDef = new ManagedList();
        if (convertersElement != null) {
            convertersDef.setSource(source);
            for (Element beanElement : DomUtils.getChildElementsByTagName((Element)convertersElement, (String[])new String[]{"bean", "ref"})) {
                Object object = parserCxt.getDelegate().parsePropertySubElement(beanElement, null);
                convertersDef.add(object);
            }
        }
        if (convertersElement == null || Boolean.valueOf(convertersElement.getAttribute("register-defaults")).booleanValue()) {
            convertersDef.setSource(source);
            if (jackson2Present) {
                RootBeanDefinition jacksonConverterDef = new RootBeanDefinition(MappingJackson2MessageConverter.class);
                RootBeanDefinition resolverDef = new RootBeanDefinition(DefaultContentTypeResolver.class);
                resolverDef.getPropertyValues().add("defaultMimeType", (Object)MimeTypeUtils.APPLICATION_JSON);
                jacksonConverterDef.getPropertyValues().add("contentTypeResolver", (Object)resolverDef);
                convertersDef.add((Object)jacksonConverterDef);
            }
            convertersDef.add((Object)new RootBeanDefinition(StringMessageConverter.class));
            convertersDef.add((Object)new RootBeanDefinition(ByteArrayMessageConverter.class));
        }
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)convertersDef);
        RootBeanDefinition brokerMessage = new RootBeanDefinition(CompositeMessageConverter.class, cavs, null);
        return new RuntimeBeanReference(MessageBrokerBeanDefinitionParser.registerBeanDef(brokerMessage, parserCxt, source));
    }

    private RuntimeBeanReference registerBrokerMessagingTemplate(Element element, RuntimeBeanReference brokerChannelDef, RuntimeBeanReference messageConverterRef, ParserContext parserCxt, Object source) {
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)brokerChannelDef);
        RootBeanDefinition messagingTemplateDef = new RootBeanDefinition(SimpMessagingTemplate.class, cavs, null);
        String userDestinationPrefixAttribute = element.getAttribute("user-destination-prefix");
        if (!userDestinationPrefixAttribute.isEmpty()) {
            messagingTemplateDef.getPropertyValues().add("userDestinationPrefix", (Object)userDestinationPrefixAttribute);
        }
        messagingTemplateDef.getPropertyValues().add("messageConverter", (Object)messageConverterRef);
        return new RuntimeBeanReference(MessageBrokerBeanDefinitionParser.registerBeanDef(messagingTemplateDef, parserCxt, source));
    }

    private void registerAnnotationMethodMessageHandler(Element messageBrokerElement, RuntimeBeanReference clientInChannelDef, RuntimeBeanReference clientOutChannelDef, RuntimeBeanReference brokerMessageConverterRef, RuntimeBeanReference brokerMessagingTemplateRef, ParserContext parserCxt, Object source) {
        String appDestPrefix = messageBrokerElement.getAttribute("application-destination-prefix");
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)clientInChannelDef);
        cavs.addIndexedArgumentValue(1, (Object)clientOutChannelDef);
        cavs.addIndexedArgumentValue(2, (Object)brokerMessagingTemplateRef);
        MutablePropertyValues mpvs = new MutablePropertyValues();
        mpvs.add("destinationPrefixes", Arrays.asList(StringUtils.tokenizeToStringArray((String)appDestPrefix, (String)",")));
        mpvs.add("messageConverter", (Object)brokerMessageConverterRef);
        RootBeanDefinition annotationMethodMessageHandlerDef = new RootBeanDefinition(SimpAnnotationMethodMessageHandler.class, cavs, mpvs);
        MessageBrokerBeanDefinitionParser.registerBeanDef(annotationMethodMessageHandlerDef, parserCxt, source);
    }

    private RuntimeBeanReference registerUserDestinationResolver(Element messageBrokerElement, RuntimeBeanReference userSessionRegistry, ParserContext parserCxt, Object source) {
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)userSessionRegistry);
        RootBeanDefinition userDestinationResolverDef = new RootBeanDefinition(DefaultUserDestinationResolver.class, cavs, null);
        String prefix = messageBrokerElement.getAttribute("user-destination-prefix");
        if (!prefix.isEmpty()) {
            userDestinationResolverDef.getPropertyValues().add("userDestinationPrefix", (Object)prefix);
        }
        String userDestinationResolverName = MessageBrokerBeanDefinitionParser.registerBeanDef(userDestinationResolverDef, parserCxt, source);
        return new RuntimeBeanReference(userDestinationResolverName);
    }

    private RuntimeBeanReference registerUserDestinationMessageHandler(RuntimeBeanReference clientInChannelDef, RuntimeBeanReference clientOutChannelDef, RuntimeBeanReference brokerChannelDef, RuntimeBeanReference userDestinationResolverRef, ParserContext parserCxt, Object source) {
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)clientInChannelDef);
        cavs.addIndexedArgumentValue(1, (Object)brokerChannelDef);
        cavs.addIndexedArgumentValue(2, (Object)userDestinationResolverRef);
        RootBeanDefinition userDestinationMessageHandlerDef = new RootBeanDefinition(UserDestinationMessageHandler.class, cavs, null);
        String userDestinationMessageHandleName = MessageBrokerBeanDefinitionParser.registerBeanDef(userDestinationMessageHandlerDef, parserCxt, source);
        return new RuntimeBeanReference(userDestinationMessageHandleName);
    }

    private static String registerBeanDef(RootBeanDefinition beanDef, ParserContext parserCxt, Object source) {
        String beanName = parserCxt.getReaderContext().generateBeanName((BeanDefinition)beanDef);
        MessageBrokerBeanDefinitionParser.registerBeanDefByName(beanName, beanDef, parserCxt, source);
        return beanName;
    }

    private static void registerBeanDefByName(String beanName, RootBeanDefinition beanDef, ParserContext parserCxt, Object source) {
        beanDef.setSource(source);
        beanDef.setRole(2);
        parserCxt.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)beanDef);
        parserCxt.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)beanDef, beanName));
    }
}

