/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpLogging;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.DefaultSslInfo;
import org.springframework.http.server.reactive.NettyHeadersAdapter;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.netty.ChannelOperationsId;
import reactor.netty.Connection;
import reactor.netty.http.server.HttpServerRequest;

class ReactorServerHttpRequest
extends AbstractServerHttpRequest {
    private static final Log logger = HttpLogging.forLogName(ReactorServerHttpRequest.class);
    private static final AtomicLong logPrefixIndex = new AtomicLong();
    private final HttpServerRequest request;
    private final NettyDataBufferFactory bufferFactory;

    public ReactorServerHttpRequest(HttpServerRequest request, NettyDataBufferFactory bufferFactory) throws URISyntaxException {
        super(ReactorServerHttpRequest.initUri(request), "", new NettyHeadersAdapter(request.requestHeaders()));
        Assert.notNull((Object)bufferFactory, (String)"DataBufferFactory must not be null");
        this.request = request;
        this.bufferFactory = bufferFactory;
    }

    private static URI initUri(HttpServerRequest request) throws URISyntaxException {
        Assert.notNull((Object)request, (String)"HttpServerRequest must not be null");
        return new URI(ReactorServerHttpRequest.resolveBaseUrl(request) + ReactorServerHttpRequest.resolveRequestUri(request));
    }

    private static URI resolveBaseUrl(HttpServerRequest request) throws URISyntaxException {
        String scheme = ReactorServerHttpRequest.getScheme(request);
        String header = request.requestHeaders().get((CharSequence)HttpHeaderNames.HOST);
        if (header != null) {
            int portIndex = header.startsWith("[") ? header.indexOf(58, header.indexOf(93)) : header.indexOf(58);
            if (portIndex != -1) {
                try {
                    return new URI(scheme, null, header.substring(0, portIndex), Integer.parseInt(header, portIndex + 1, header.length(), 10), null, null, null);
                }
                catch (NumberFormatException ex) {
                    throw new URISyntaxException(header, "Unable to parse port", portIndex);
                }
            }
            return new URI(scheme, header, null, null);
        }
        InetSocketAddress localAddress = request.hostAddress();
        Assert.state((localAddress != null ? 1 : 0) != 0, (String)"No host address available");
        return new URI(scheme, null, localAddress.getHostString(), localAddress.getPort(), null, null, null);
    }

    private static String getScheme(HttpServerRequest request) {
        return request.scheme();
    }

    private static String resolveRequestUri(HttpServerRequest request) {
        char c;
        String uri = request.uri();
        for (int i = 0; i < uri.length() && (c = uri.charAt(i)) != '/' && c != '?' && c != '#'; ++i) {
            if (c != ':' || i + 2 >= uri.length() || uri.charAt(i + 1) != '/' || uri.charAt(i + 2) != '/') continue;
            for (int j = i + 3; j < uri.length(); ++j) {
                c = uri.charAt(j);
                if (c != '/' && c != '?' && c != '#') continue;
                return uri.substring(j);
            }
            return "";
        }
        return uri;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.request.method().name());
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (CharSequence name : this.request.cookies().keySet()) {
            for (Cookie cookie : (Set)this.request.cookies().get(name)) {
                HttpCookie httpCookie = new HttpCookie(name.toString(), cookie.value());
                cookies.add((Object)name.toString(), (Object)httpCookie);
            }
        }
        return cookies;
    }

    @Override
    @Nullable
    public InetSocketAddress getLocalAddress() {
        return this.request.hostAddress();
    }

    @Override
    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.request.remoteAddress();
    }

    @Override
    @Nullable
    protected SslInfo initSslInfo() {
        Channel channel = ((Connection)this.request).channel();
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        if (sslHandler == null && channel.parent() != null) {
            sslHandler = (SslHandler)channel.parent().pipeline().get(SslHandler.class);
        }
        if (sslHandler != null) {
            SSLSession session = sslHandler.engine().getSession();
            return new DefaultSslInfo(session);
        }
        return null;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.request.receive().retain().map(arg_0 -> ((NettyDataBufferFactory)this.bufferFactory).wrap(arg_0));
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.request;
    }

    @Override
    @Nullable
    protected String initId() {
        if (this.request instanceof Connection) {
            return ((Connection)this.request).channel().id().asShortText() + "-" + logPrefixIndex.incrementAndGet();
        }
        return null;
    }

    @Override
    protected String initLogPrefix() {
        String id = null;
        HttpServerRequest httpServerRequest = this.request;
        if (httpServerRequest instanceof ChannelOperationsId) {
            ChannelOperationsId operationsId = (ChannelOperationsId)httpServerRequest;
            String string = id = logger.isDebugEnabled() ? operationsId.asLongText() : operationsId.asShortText();
        }
        if (id != null) {
            return id;
        }
        if (this.request instanceof Connection) {
            return ((Connection)this.request).channel().id().asShortText() + "-" + logPrefixIndex.incrementAndGet();
        }
        return this.getId();
    }
}

