/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class WebUtils {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    public static final String TEMP_DIR_CONTEXT_ATTRIBUTE = "javax.servlet.context.tempdir";
    public static final String HTML_ESCAPE_CONTEXT_PARAM = "defaultHtmlEscape";
    public static final String WEB_APP_ROOT_KEY_PARAM = "webAppRootKey";
    public static final String DEFAULT_WEB_APP_ROOT_KEY = "webapp.root";
    public static final String SESSION_MUTEX_ATTRIBUTE = (class$org$springframework$web$util$WebUtils == null ? (class$org$springframework$web$util$WebUtils = WebUtils.class$("org.springframework.web.util.WebUtils")) : class$org$springframework$web$util$WebUtils).getName() + ".MUTEX";
    public static final String[] SUBMIT_IMAGE_SUFFIXES = new String[]{".x", ".y"};
    static /* synthetic */ Class class$org$springframework$web$util$WebUtils;

    public static void setWebAppRootSystemProperty(ServletContext servletContext) throws IllegalStateException {
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        String root = servletContext.getRealPath("/");
        if (root == null) {
            throw new IllegalStateException("Cannot set web app root system property when WAR file is not expanded");
        }
        String param = servletContext.getInitParameter(WEB_APP_ROOT_KEY_PARAM);
        String key = param != null ? param : DEFAULT_WEB_APP_ROOT_KEY;
        String oldValue = System.getProperty(key);
        if (oldValue != null && !StringUtils.pathEquals((String)oldValue, (String)root)) {
            throw new IllegalStateException("Web app root system property already set to different value: '" + key + "' = [" + oldValue + "] instead of [" + root + "] - " + "Choose unique values for the 'webAppRootKey' context-param in your web.xml files!");
        }
        System.setProperty(key, root);
        servletContext.log("Set web app root system property: '" + key + "' = [" + root + "]");
    }

    public static void removeWebAppRootSystemProperty(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        String param = servletContext.getInitParameter(WEB_APP_ROOT_KEY_PARAM);
        String key = param != null ? param : DEFAULT_WEB_APP_ROOT_KEY;
        System.getProperties().remove(key);
    }

    public static boolean isDefaultHtmlEscape(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        String param = servletContext.getInitParameter(HTML_ESCAPE_CONTEXT_PARAM);
        return Boolean.valueOf(param);
    }

    public static File getTempDir(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        return (File)servletContext.getAttribute(TEMP_DIR_CONTEXT_ATTRIBUTE);
    }

    public static String getRealPath(ServletContext servletContext, String path) throws FileNotFoundException {
        String realPath;
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((realPath = servletContext.getRealPath(path)) == null) {
            throw new FileNotFoundException("ServletContext resource [" + path + "] cannot be resolved to absolute file path - " + "web application archive not expanded?");
        }
        return realPath;
    }

    public static String getSessionId(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        HttpSession session = request.getSession(false);
        return session != null ? session.getId() : null;
    }

    public static Object getSessionAttribute(HttpServletRequest request, String name) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        HttpSession session = request.getSession(false);
        return session != null ? session.getAttribute(name) : null;
    }

    public static Object getRequiredSessionAttribute(HttpServletRequest request, String name) throws IllegalStateException {
        Object attr = WebUtils.getSessionAttribute(request, name);
        if (attr == null) {
            throw new IllegalStateException("No session attribute '" + name + "' found");
        }
        return attr;
    }

    public static void setSessionAttribute(HttpServletRequest request, String name, Object value) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        if (value != null) {
            request.getSession().setAttribute(name, value);
        } else {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(name);
            }
        }
    }

    public static Object getOrCreateSessionAttribute(HttpSession session, String name, Class clazz) throws IllegalArgumentException {
        Assert.notNull((Object)session, (String)"Session must not be null");
        Object sessionObject = session.getAttribute(name);
        if (sessionObject == null) {
            try {
                sessionObject = clazz.newInstance();
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException("Could not instantiate class [" + clazz.getName() + "] for session attribute '" + name + "': " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Could not access default constructor of class [" + clazz.getName() + "] for session attribute '" + name + "': " + ex.getMessage());
            }
            session.setAttribute(name, sessionObject);
        }
        return sessionObject;
    }

    public static Object getSessionMutex(HttpSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        Object mutex = session.getAttribute(SESSION_MUTEX_ATTRIBUTE);
        if (mutex == null) {
            mutex = session;
        }
        return mutex;
    }

    public static void exposeRequestAttributes(ServletRequest request, Map attributes) throws IllegalArgumentException {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Invalid key [" + entry.getKey() + "] in attributes Map - only Strings allowed as attribute keys");
            }
            request.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!name.equals(cookies[i].getName())) continue;
                return cookies[i];
            }
        }
        return null;
    }

    public static boolean hasSubmitParameter(ServletRequest request, String name) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        if (request.getParameter(name) != null) {
            return true;
        }
        for (int i = 0; i < SUBMIT_IMAGE_SUFFIXES.length; ++i) {
            String suffix = SUBMIT_IMAGE_SUFFIXES[i];
            if (request.getParameter(name + suffix) == null) continue;
            return true;
        }
        return false;
    }

    public static Map getParametersStartingWith(ServletRequest request, String prefix) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Enumeration paramNames = request.getParameterNames();
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        if (prefix == null) {
            prefix = "";
        }
        while (paramNames != null && paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!"".equals(prefix) && !paramName.startsWith(prefix)) continue;
            String unprefixed = paramName.substring(prefix.length());
            String[] values = request.getParameterValues(paramName);
            if (values == null) continue;
            if (values.length > 1) {
                params.put(unprefixed, values);
                continue;
            }
            params.put(unprefixed, values[0]);
        }
        return params;
    }

    public static String extractFilenameFromUrlPath(String urlPath) {
        String filename;
        int dotIndex;
        int begin = urlPath.lastIndexOf(47) + 1;
        int end = urlPath.indexOf(59);
        if (end == -1 && (end = urlPath.indexOf(63)) == -1) {
            end = urlPath.length();
        }
        if ((dotIndex = (filename = urlPath.substring(begin, end)).lastIndexOf(46)) != -1) {
            filename = filename.substring(0, dotIndex);
        }
        return filename;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

