/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.FileCopyUtils;

class JsonLoader {
    @Nullable
    private final Class<?> resourceLoadClass;
    private final Charset charset;

    JsonLoader(@Nullable Class<?> resourceLoadClass, @Nullable Charset charset) {
        this.resourceLoadClass = resourceLoadClass;
        this.charset = charset != null ? charset : StandardCharsets.UTF_8;
    }

    @Nullable
    String getJson(@Nullable CharSequence source) {
        if (source == null) {
            return null;
        }
        String jsonSource = source.toString();
        if (jsonSource.endsWith(".json")) {
            return this.getJson((Resource)new ClassPathResource(jsonSource, this.resourceLoadClass));
        }
        return jsonSource;
    }

    String getJson(Resource source) {
        try {
            return this.getJson(source.getInputStream());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load JSON from " + source, ex);
        }
    }

    private String getJson(InputStream source) throws IOException {
        return FileCopyUtils.copyToString((Reader)new InputStreamReader(source, this.charset));
    }
}

