/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import javax.servlet.http.Cookie;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MockCookie
extends Cookie {
    private static final long serialVersionUID = 4312531139502726325L;
    @Nullable
    private String sameSite;

    public MockCookie(String name, String value) {
        super(name, value);
    }

    public void setSameSite(@Nullable String sameSite) {
        this.sameSite = sameSite;
    }

    @Nullable
    public String getSameSite() {
        return this.sameSite;
    }

    public static MockCookie parse(String setCookieHeader) {
        String[] cookieParts = setCookieHeader.split("\\s*=\\s*", 2);
        Assert.isTrue((cookieParts.length == 2 ? 1 : 0) != 0, (String)"Invalid Set-Cookie header value");
        String name = cookieParts[0];
        String[] valueAndDirectives = cookieParts[1].split("\\s*;\\s*", 2);
        String value = valueAndDirectives[0];
        String[] directives = valueAndDirectives[1].split("\\s*;\\s*");
        MockCookie cookie = new MockCookie(name, value);
        for (String directive : directives) {
            if (directive.startsWith("Domain")) {
                cookie.setDomain(MockCookie.extractDirectiveValue(directive));
                continue;
            }
            if (directive.startsWith("Max-Age")) {
                cookie.setMaxAge(Integer.parseInt(MockCookie.extractDirectiveValue(directive)));
                continue;
            }
            if (directive.startsWith("Path")) {
                cookie.setPath(MockCookie.extractDirectiveValue(directive));
                continue;
            }
            if (directive.startsWith("Secure")) {
                cookie.setSecure(true);
                continue;
            }
            if (directive.startsWith("HttpOnly")) {
                cookie.setHttpOnly(true);
                continue;
            }
            if (!directive.startsWith("SameSite")) continue;
            cookie.setSameSite(MockCookie.extractDirectiveValue(directive));
        }
        return cookie;
    }

    private static String extractDirectiveValue(String directive) {
        String[] nameAndValue = directive.split("=");
        Assert.isTrue((nameAndValue.length == 2 ? 1 : 0) != 0, () -> "No value in directive: '" + directive + "'");
        return nameAndValue[1];
    }
}

