/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jdbc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.List;
import org.springframework.util.StringUtils;

public class JdbcTestUtils {
    public static String readScript(LineNumberReader lineNumberReader) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuffer scriptBuilder = new StringBuffer();
        while (currentStatement != null) {
            if (StringUtils.hasText((String)currentStatement)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        return scriptBuilder.toString();
    }

    public static boolean containsSqlScriptDelimiters(String script, char delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (content[i] != delim || inLiteral) continue;
            return true;
        }
        return false;
    }

    public static void splitSqlScript(String script, char delim, List statements) {
        StringBuffer sb = new StringBuffer();
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (content[i] == delim && !inLiteral) {
                if (sb.length() <= 0) continue;
                statements.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            sb.append(content[i]);
        }
        if (sb.length() > 0) {
            statements.add(sb.toString());
        }
    }
}

