/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate5;

import org.hibernate.Session;
import org.jspecify.annotations.Nullable;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronization;

public class SpringFlushSynchronization
implements TransactionSynchronization {
    private final Session session;

    public SpringFlushSynchronization(Session session) {
        this.session = session;
    }

    public void flush() {
        SessionFactoryUtils.flush(this.session, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof SpringFlushSynchronization)) return false;
        SpringFlushSynchronization that = (SpringFlushSynchronization)other;
        if (this.session != that.session) return false;
        return true;
    }

    public int hashCode() {
        return this.session.hashCode();
    }
}

