/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.support.control;

import com.sun.jndi.ldap.ctl.PagedResultsControl;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import org.springframework.ldap.UncategorizedLdapException;
import org.springframework.ldap.support.control.AbstractRequestControlDirContextProcessor;
import org.springframework.ldap.support.control.PagedResultsCookie;
import org.springframework.util.ReflectionUtils;

public class PagedResultsRequestControl
extends AbstractRequestControlDirContextProcessor {
    private static final Class DEFAULT_RESPONSE_CONTROL = class$com$sun$jndi$ldap$ctl$PagedResultsResponseControl == null ? (class$com$sun$jndi$ldap$ctl$PagedResultsResponseControl = PagedResultsRequestControl.class$("com.sun.jndi.ldap.ctl.PagedResultsResponseControl")) : class$com$sun$jndi$ldap$ctl$PagedResultsResponseControl;
    private static final boolean CRITICAL_CONTROL = true;
    private static final String JAVA5_RESPONSE_CONTROL = "javax.naming.ldap.PagedResultsResponseControl";
    private int pageSize;
    private PagedResultsCookie cookie;
    private int resultSize;
    private Class responseControlClass = DEFAULT_RESPONSE_CONTROL;
    private Class fallbackResponseControlClass;
    private Class currentResponseControlClass;
    static /* synthetic */ Class class$com$sun$jndi$ldap$ctl$PagedResultsResponseControl;

    public PagedResultsRequestControl(int pageSize) {
        this(pageSize, null);
    }

    public PagedResultsRequestControl(int pageSize, PagedResultsCookie cookie) {
        this.pageSize = pageSize;
        this.cookie = cookie;
        this.fallbackResponseControlClass = this.loadFallbackResponseControlClass();
    }

    public PagedResultsCookie getCookie() {
        return this.cookie;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getResultSize() {
        return this.resultSize;
    }

    public void setResponseControlClass(Class responseControlClass) {
        this.responseControlClass = responseControlClass;
    }

    public Control createRequestControl() {
        try {
            if (this.cookie != null) {
                return new PagedResultsControl(this.pageSize, this.cookie.getCookie(), true);
            }
            return new PagedResultsControl(this.pageSize);
        }
        catch (IOException e) {
            throw new UncategorizedLdapException("Error creating PagedResultsControl", e);
        }
    }

    public void postProcess(DirContext ctx) throws NamingException {
        this.currentResponseControlClass = this.responseControlClass;
        LdapContext ldapContext = (LdapContext)ctx;
        Control[] responseControls = ldapContext.getResponseControls();
        for (int i = 0; i < responseControls.length; ++i) {
            Control responseControl = responseControls[i];
            if (!this.isPagedResultsResponseControl(responseControl)) continue;
            Control control = responseControl;
            byte[] result = (byte[])this.invokeMethod("getCookie", this.currentResponseControlClass, control);
            this.cookie = new PagedResultsCookie(result);
            Integer wrapper = (Integer)this.invokeMethod("getResultSize", this.currentResponseControlClass, control);
            this.resultSize = wrapper;
        }
    }

    private boolean isPagedResultsResponseControl(Control responseControl) {
        if (responseControl.getClass().isAssignableFrom(this.currentResponseControlClass)) {
            return true;
        }
        if (this.fallbackResponseControlClass != null && responseControl.getClass().isAssignableFrom(this.fallbackResponseControlClass)) {
            this.currentResponseControlClass = this.fallbackResponseControlClass;
            return true;
        }
        return false;
    }

    private Class loadFallbackResponseControlClass() {
        Class<?> fallbackResponseControlClass = null;
        try {
            fallbackResponseControlClass = Class.forName(JAVA5_RESPONSE_CONTROL);
        }
        catch (ClassNotFoundException e) {
            this.log.debug((Object)"Could not load Java5 response control class javax.naming.ldap.PagedResultsResponseControl");
        }
        return fallbackResponseControlClass;
    }

    private Object invokeMethod(String method, Class clazz, Object control) {
        Method actualMethod = null;
        Object retval = null;
        try {
            actualMethod = clazz.getMethod(method, new Class[0]);
        }
        catch (SecurityException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (NoSuchMethodException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        try {
            retval = actualMethod.invoke(control, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

