/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.object.SqlOperation;

public abstract class SqlQuery<T>
extends SqlOperation {
    public SqlQuery() {
    }

    public SqlQuery(DataSource ds, String sql) {
        this.setDataSource(ds);
        this.setSql(sql);
    }

    public List<T> execute(Object @Nullable [] params, @Nullable Map<?, ?> context) throws DataAccessException {
        this.validateParameters(params);
        RowMapper<T> rowMapper = this.newRowMapper(params, context);
        return this.getJdbcTemplate().query(this.newPreparedStatementCreator(params), rowMapper);
    }

    public Stream<T> stream(Object @Nullable [] params, @Nullable Map<?, ?> context) throws DataAccessException {
        this.validateParameters(params);
        RowMapper<T> rowMapper = this.newRowMapper(params, context);
        return this.getJdbcTemplate().queryForStream(this.newPreparedStatementCreator(params), rowMapper);
    }

    public List<T> execute(Object ... params) throws DataAccessException {
        return this.execute(params, null);
    }

    public Stream<T> stream(Object ... params) throws DataAccessException {
        return this.stream(params, null);
    }

    public List<T> execute(Map<?, ?> context) throws DataAccessException {
        return this.execute((Object[])null, context);
    }

    public Stream<T> stream(Map<?, ?> context) throws DataAccessException {
        return this.stream(null, context);
    }

    public List<T> execute() throws DataAccessException {
        return this.execute((Object[])null, null);
    }

    public Stream<T> stream() throws DataAccessException {
        return this.stream(null, null);
    }

    public List<T> execute(int p1, @Nullable Map<?, ?> context) throws DataAccessException {
        return this.execute(new Object[]{p1}, context);
    }

    public List<T> execute(int p1) throws DataAccessException {
        return this.execute(p1, (Map<?, ?>)null);
    }

    public List<T> execute(int p1, int p2, @Nullable Map<?, ?> context) throws DataAccessException {
        return this.execute(new Object[]{p1, p2}, context);
    }

    public List<T> execute(int p1, int p2) throws DataAccessException {
        return this.execute(p1, p2, null);
    }

    public List<T> execute(long p1, @Nullable Map<?, ?> context) throws DataAccessException {
        return this.execute(new Object[]{p1}, context);
    }

    public List<T> execute(long p1) throws DataAccessException {
        return this.execute(p1, null);
    }

    public List<T> execute(String p1, @Nullable Map<?, ?> context) throws DataAccessException {
        return this.execute(new Object[]{p1}, context);
    }

    public List<T> execute(String p1) throws DataAccessException {
        return this.execute(p1, null);
    }

    public List<T> executeByNamedParam(Map<String, ?> paramMap, @Nullable Map<?, ?> context) throws DataAccessException {
        return this.queryByNamedParam(paramMap, context, this.getJdbcTemplate()::query);
    }

    public Stream<T> streamByNamedParam(Map<String, ?> paramMap, @Nullable Map<?, ?> context) throws DataAccessException {
        return this.queryByNamedParam(paramMap, context, this.getJdbcTemplate()::queryForStream);
    }

    public List<T> executeByNamedParam(Map<String, ? extends @Nullable Object> paramMap) throws DataAccessException {
        return this.executeByNamedParam(paramMap, null);
    }

    public Stream<T> streamByNamedParam(Map<String, ? extends @Nullable Object> paramMap) throws DataAccessException {
        return this.streamByNamedParam(paramMap, null);
    }

    private <R> R queryByNamedParam(Map<String, ?> paramMap, @Nullable Map<?, ?> context, BiFunction<PreparedStatementCreator, RowMapper<T>, R> queryFunction) {
        this.validateNamedParameters(paramMap);
        ParsedSql parsedSql = this.getParsedSql();
        MapSqlParameterSource paramSource = new MapSqlParameterSource(paramMap);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(parsedSql, (SqlParameterSource)paramSource);
        @Nullable Object[] params = NamedParameterUtils.buildValueArray(parsedSql, paramSource, this.getDeclaredParameters());
        RowMapper<T> rowMapper = this.newRowMapper(params, context);
        return queryFunction.apply(this.newPreparedStatementCreator(sqlToUse, params), rowMapper);
    }

    public @Nullable T findObject(Object @Nullable [] params, @Nullable Map<?, ?> context) throws DataAccessException {
        List<T> results = this.execute(params, context);
        return (T)DataAccessUtils.singleResult(results);
    }

    public @Nullable T findObject(Object ... params) throws DataAccessException {
        return this.findObject(params, null);
    }

    public @Nullable T findObject(int p1, @Nullable Map<?, ?> context) throws DataAccessException {
        return this.findObject(new Object[]{p1}, context);
    }

    public @Nullable T findObject(int p1) throws DataAccessException {
        return this.findObject(p1, (Map<?, ?>)null);
    }

    public @Nullable T findObject(int p1, int p2, @Nullable Map<?, ?> context) throws DataAccessException {
        return this.findObject(new Object[]{p1, p2}, context);
    }

    public @Nullable T findObject(int p1, int p2) throws DataAccessException {
        return this.findObject(p1, p2, null);
    }

    public @Nullable T findObject(long p1, @Nullable Map<?, ?> context) throws DataAccessException {
        return this.findObject(new Object[]{p1}, context);
    }

    public @Nullable T findObject(long p1) throws DataAccessException {
        return this.findObject(p1, null);
    }

    public @Nullable T findObject(String p1, @Nullable Map<?, ?> context) throws DataAccessException {
        return this.findObject(new Object[]{p1}, context);
    }

    public @Nullable T findObject(String p1) throws DataAccessException {
        return this.findObject(p1, null);
    }

    public @Nullable T findObjectByNamedParam(Map<String, ?> paramMap, @Nullable Map<?, ?> context) throws DataAccessException {
        List<T> results = this.executeByNamedParam(paramMap, context);
        return (T)DataAccessUtils.singleResult(results);
    }

    public @Nullable T findObjectByNamedParam(Map<String, ?> paramMap) throws DataAccessException {
        return this.findObjectByNamedParam(paramMap, null);
    }

    protected abstract RowMapper<T> newRowMapper(@Nullable Object @Nullable [] var1, @Nullable Map<?, ?> var2);
}

