/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationMethod;
import org.springframework.core.type.MethodMetadata;
import org.springframework.lang.Nullable;

final class BeanMethod
extends ConfigurationMethod {
    BeanMethod(MethodMetadata metadata, ConfigurationClass configurationClass) {
        super(metadata, configurationClass);
    }

    @Override
    public void validate(ProblemReporter problemReporter) {
        if (this.getMetadata().isStatic()) {
            return;
        }
        if (this.configurationClass.getMetadata().isAnnotated(Configuration.class.getName()) && !this.getMetadata().isOverridable()) {
            problemReporter.error((Problem)new NonOverridableMethodError());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof BeanMethod)) return false;
        BeanMethod that = (BeanMethod)obj;
        if (!this.metadata.equals(that.metadata)) return false;
        return true;
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public String toString() {
        return "BeanMethod: " + this.metadata;
    }

    private class NonOverridableMethodError
    extends Problem {
        NonOverridableMethodError() {
            super("@Bean method '%s' must not be private or final; change the method's modifiers to continue.".formatted(BeanMethod.this.getMetadata().getMethodName()), BeanMethod.this.getResourceLocation());
        }
    }
}

