/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.support;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.format.Formatter;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FormatterPropertyEditorAdapter
extends PropertyEditorSupport {
    private final Formatter<Object> formatter;

    public FormatterPropertyEditorAdapter(Formatter<?> formatter) {
        Assert.notNull(formatter, (String)"Formatter must not be null");
        this.formatter = formatter;
    }

    public Class<?> getFieldType() {
        return FormattingConversionService.getFieldType(this.formatter);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText((String)text)) {
            try {
                this.setValue(this.formatter.parse(text, LocaleContextHolder.getLocale()));
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Parse attempt failed for value [" + text + "]", ex);
            }
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        return value != null ? this.formatter.print(value, LocaleContextHolder.getLocale()) : "";
    }
}

