/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api;

import java.io.Serializable;
import java.util.Arrays;
import org.springframework.social.twitter.api.TwitterObject;

public class UrlEntity
extends TwitterObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String display;
    private String expanded;
    private String url;
    private int[] indices;

    public UrlEntity(String display, String expanded, String url, int[] indices) {
        this.display = display;
        this.expanded = expanded;
        this.url = url;
        this.indices = indices;
    }

    public String getDisplayUrl() {
        return this.display;
    }

    public String getExpandedUrl() {
        return this.expanded;
    }

    public String getUrl() {
        return this.url;
    }

    public int[] getIndices() {
        if (this.indices == null || this.indices.length <= 0) {
            return new int[0];
        }
        return this.indices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlEntity urlEntity = (UrlEntity)o;
        if (this.display != null ? !this.display.equals(urlEntity.display) : urlEntity.display != null) {
            return false;
        }
        if (this.expanded != null ? !this.expanded.equals(urlEntity.expanded) : urlEntity.expanded != null) {
            return false;
        }
        if (!Arrays.equals(this.indices, urlEntity.indices)) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(urlEntity.url) : urlEntity.url != null);
    }

    public int hashCode() {
        int result = this.display != null ? this.display.hashCode() : 0;
        result = 31 * result + (this.expanded != null ? this.expanded.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.indices != null ? Arrays.hashCode(this.indices) : 0);
        return result;
    }
}

