/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.springframework.social.facebook.api.ListAndCount;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.impl.json.FacebookModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceListAndCountDeserializer
extends JsonDeserializer<ListAndCount<Reference>> {
    ReferenceListAndCountDeserializer() {
    }

    public ListAndCount<Reference> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new FacebookModule());
        jp.setCodec((ObjectCodec)mapper);
        if (jp.hasCurrentToken()) {
            JsonNode node = (JsonNode)jp.readValueAs(JsonNode.class);
            JsonNode dataNode = node.get("data");
            List commentsList = dataNode != null ? (List)mapper.reader((TypeReference)new TypeReference<List<Reference>>(){}).readValue(dataNode) : Collections.emptyList();
            JsonNode countNode = node.get("count");
            int referenceCount = countNode != null ? countNode.intValue() : 0;
            return new ListAndCount<Reference>(commentsList, referenceCount);
        }
        return null;
    }
}

