/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.jdbc.config.annotation.web.http;

import java.sql.DatabaseMetaData;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.session.FlushMode;
import org.springframework.session.IndexResolver;
import org.springframework.session.MapSession;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.SessionIdGenerator;
import org.springframework.session.SessionRepository;
import org.springframework.session.UuidSessionIdGenerator;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.jdbc.JdbcIndexedSessionRepository;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.jdbc.config.annotation.web.http.EnableJdbcHttpSession;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration(proxyBeanMethods=false)
@Import(value={SpringHttpSessionConfiguration.class})
public class JdbcHttpSessionConfiguration
implements BeanClassLoaderAware,
EmbeddedValueResolverAware,
ImportAware {
    private Duration maxInactiveInterval = MapSession.DEFAULT_MAX_INACTIVE_INTERVAL;
    private String tableName = "SPRING_SESSION";
    private String cleanupCron = "0 * * * * *";
    private FlushMode flushMode = FlushMode.ON_SAVE;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    private DataSource dataSource;
    private PlatformTransactionManager transactionManager;
    private TransactionOperations transactionOperations;
    private IndexResolver<Session> indexResolver;
    private LobHandler lobHandler;
    private ConversionService springSessionConversionService;
    private ConversionService conversionService;
    private List<SessionRepositoryCustomizer<JdbcIndexedSessionRepository>> sessionRepositoryCustomizers;
    private ClassLoader classLoader;
    private StringValueResolver embeddedValueResolver;
    private SessionIdGenerator sessionIdGenerator = UuidSessionIdGenerator.getInstance();

    @Bean
    public JdbcIndexedSessionRepository sessionRepository() {
        JdbcTemplate jdbcTemplate = JdbcHttpSessionConfiguration.createJdbcTemplate(this.dataSource);
        if (this.transactionOperations == null) {
            this.transactionOperations = JdbcHttpSessionConfiguration.createTransactionTemplate(this.transactionManager);
        }
        JdbcIndexedSessionRepository sessionRepository = new JdbcIndexedSessionRepository((JdbcOperations)jdbcTemplate, this.transactionOperations);
        if (StringUtils.hasText((String)this.tableName)) {
            sessionRepository.setTableName(this.tableName);
        }
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveInterval);
        sessionRepository.setFlushMode(this.flushMode);
        sessionRepository.setSaveMode(this.saveMode);
        sessionRepository.setCleanupCron(this.cleanupCron);
        if (this.indexResolver != null) {
            sessionRepository.setIndexResolver(this.indexResolver);
        }
        if (this.lobHandler != null) {
            sessionRepository.setLobHandler(this.lobHandler);
        } else if (JdbcHttpSessionConfiguration.requiresTemporaryLob(this.dataSource)) {
            DefaultLobHandler lobHandler = new DefaultLobHandler();
            lobHandler.setCreateTemporaryLob(true);
            sessionRepository.setLobHandler((LobHandler)lobHandler);
        }
        if (this.springSessionConversionService != null) {
            sessionRepository.setConversionService(this.springSessionConversionService);
        } else if (this.conversionService != null) {
            sessionRepository.setConversionService(this.conversionService);
        } else {
            sessionRepository.setConversionService((ConversionService)JdbcHttpSessionConfiguration.createConversionServiceWithBeanClassLoader(this.classLoader));
        }
        sessionRepository.setSessionIdGenerator(this.sessionIdGenerator);
        this.sessionRepositoryCustomizers.forEach(sessionRepositoryCustomizer -> sessionRepositoryCustomizer.customize((SessionRepository)sessionRepository));
        return sessionRepository;
    }

    private static boolean requiresTemporaryLob(DataSource dataSource) {
        try {
            String productName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductName);
            return "Oracle".equalsIgnoreCase(JdbcUtils.commonDatabaseName((String)productName));
        }
        catch (MetaDataAccessException ex) {
            return false;
        }
    }

    public void setMaxInactiveInterval(Duration maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    @Deprecated
    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.setMaxInactiveInterval(Duration.ofSeconds(maxInactiveIntervalInSeconds.intValue()));
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setCleanupCron(String cleanupCron) {
        this.cleanupCron = cleanupCron;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
    }

    @Autowired
    public void setDataSource(@SpringSessionDataSource ObjectProvider<DataSource> springSessionDataSource, ObjectProvider<DataSource> dataSource) {
        DataSource dataSourceToUse = (DataSource)springSessionDataSource.getIfAvailable();
        if (dataSourceToUse == null) {
            dataSourceToUse = (DataSource)dataSource.getObject();
        }
        this.dataSource = dataSourceToUse;
    }

    @Autowired
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionTransactionOperations")
    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
    }

    @Autowired(required=false)
    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        this.indexResolver = indexResolver;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionLobHandler")
    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionConversionService")
    public void setSpringSessionConversionService(ConversionService conversionService) {
        this.springSessionConversionService = conversionService;
    }

    @Autowired(required=false)
    @Qualifier(value="conversionService")
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Autowired(required=false)
    public void setSessionRepositoryCustomizer(ObjectProvider<SessionRepositoryCustomizer<JdbcIndexedSessionRepository>> sessionRepositoryCustomizers) {
        this.sessionRepositoryCustomizers = sessionRepositoryCustomizers.orderedStream().collect(Collectors.toList());
    }

    @Autowired(required=false)
    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        String cleanupCron;
        Map attributeMap = importMetadata.getAnnotationAttributes(EnableJdbcHttpSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        if (attributes == null) {
            return;
        }
        this.maxInactiveInterval = Duration.ofSeconds(((Integer)attributes.getNumber("maxInactiveIntervalInSeconds")).intValue());
        String tableNameValue = attributes.getString("tableName");
        if (StringUtils.hasText((String)tableNameValue)) {
            this.tableName = this.embeddedValueResolver.resolveStringValue(tableNameValue);
        }
        if (StringUtils.hasText((String)(cleanupCron = attributes.getString("cleanupCron")))) {
            this.cleanupCron = cleanupCron;
        }
        this.flushMode = (FlushMode)attributes.getEnum("flushMode");
        this.saveMode = (SaveMode)attributes.getEnum("saveMode");
    }

    private static JdbcTemplate createJdbcTemplate(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        jdbcTemplate.setExceptionTranslator((SQLExceptionTranslator)new SQLErrorCodeSQLExceptionTranslator(dataSource));
        jdbcTemplate.afterPropertiesSet();
        return jdbcTemplate;
    }

    private static TransactionTemplate createTransactionTemplate(PlatformTransactionManager transactionManager) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.afterPropertiesSet();
        return transactionTemplate;
    }

    private static GenericConversionService createConversionServiceWithBeanClassLoader(ClassLoader classLoader) {
        GenericConversionService conversionService = new GenericConversionService();
        conversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        conversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter(classLoader));
        return conversionService;
    }
}

