/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.AuthenticationSource;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.ldap.userdetails.LdapUserDetails;

public class SpringSecurityAuthenticationSource
implements AuthenticationSource {
    private static final Log log = LogFactory.getLog(SpringSecurityAuthenticationSource.class);

    public String getPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            log.warn((Object)"No Authentication object set in SecurityContext - returning empty String as Principal");
            return "";
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof LdapUserDetails) {
            LdapUserDetails details = (LdapUserDetails)principal;
            return details.getDn();
        }
        if (authentication instanceof AnonymousAuthenticationToken) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Anonymous Authentication, returning empty String as Principal");
            }
            return "";
        }
        throw new IllegalArgumentException("The principal property of the authentication objectneeds to be an LdapUserDetails.");
    }

    public String getCredentials() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            log.warn((Object)"No Authentication object set in SecurityContext - returning empty String as Credentials");
            return "";
        }
        return (String)authentication.getCredentials();
    }
}

