/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Map;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class StoredProcMessageHandler
extends AbstractMessageHandler {
    private final StoredProcExecutor executor;

    public StoredProcMessageHandler(StoredProcExecutor storedProcExecutor) {
        Assert.notNull((Object)storedProcExecutor, (String)"storedProcExecutor must not be null.");
        this.executor = storedProcExecutor;
    }

    public String getComponentType() {
        return "jdbc:stored-proc-outbound-channel-adapter";
    }

    protected void handleMessageInternal(Message<?> message) {
        Map<String, Object> resultMap = this.executor.executeStoredProcedure(message);
        if (!CollectionUtils.isEmpty(resultMap)) {
            this.logger.debug(() -> String.format("The StoredProcMessageHandler ignores return values, but the called Stored Procedure '%s' returned data: '%s'", this.executor.getStoredProcedureName(), resultMap));
        }
    }
}

