/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.util;

import java.util.function.Consumer;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class ObjectAwareUtils {
    public static final Consumer<Object> NO_OP = target -> {};

    @NonNull
    public static Consumer<Object> applicationContextAwareObjectInitializer(@Nullable ApplicationContext applicationContext) {
        return applicationContext == null ? NO_OP : target -> {
            if (target instanceof ApplicationContextAware) {
                ((ApplicationContextAware)target).setApplicationContext(applicationContext);
            }
        };
    }

    @NonNull
    public static Consumer<Object> applicationEventPublisherAwareObjectInitializer(@Nullable ApplicationEventPublisher applicationEventPublisher) {
        return applicationEventPublisher == null ? NO_OP : target -> {
            if (target instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)target).setApplicationEventPublisher(applicationEventPublisher);
            }
        };
    }

    @NonNull
    public static Consumer<Object> beanClassLoaderAwareObjectInitializer(@Nullable ClassLoader beanClassLoader) {
        return beanClassLoader == null ? NO_OP : target -> {
            if (target instanceof BeanClassLoaderAware) {
                ((BeanClassLoaderAware)target).setBeanClassLoader(beanClassLoader);
            }
        };
    }

    @NonNull
    public static Consumer<Object> beanFactoryAwareObjectInitializer(@Nullable BeanFactory beanFactory) {
        return beanFactory == null ? NO_OP : target -> {
            if (target instanceof BeanFactoryAware) {
                ((BeanFactoryAware)target).setBeanFactory(beanFactory);
            }
        };
    }

    @NonNull
    public static Consumer<Object> beanNameAwareObjectInitializer(@Nullable String beanName) {
        return ObjectAwareUtils.hasNoText(beanName) ? NO_OP : target -> {
            if (target instanceof BeanNameAware) {
                ((BeanNameAware)target).setBeanName(beanName);
            }
        };
    }

    @NonNull
    public static Consumer<Object> environmentAwareObjectInitializer(@Nullable Environment environment) {
        return environment == null ? NO_OP : target -> {
            if (target instanceof EnvironmentAware) {
                ((EnvironmentAware)target).setEnvironment(environment);
            }
        };
    }

    @NonNull
    public static Consumer<Object> resourceLoaderAwareObjectInitializer(@Nullable ResourceLoader resourceLoader) {
        return resourceLoader == null ? NO_OP : target -> {
            if (target instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)target).setResourceLoader(resourceLoader);
            }
        };
    }

    private static boolean hasNoText(@Nullable String value) {
        return !StringUtils.hasText((String)value);
    }
}

