/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.geode.config.annotation.EnableDurableClient;
import org.springframework.util.StringUtils;

@Configuration
public class DurableClientConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    public static final boolean DEFAULT_KEEP_ALIVE = true;
    public static final boolean DEFAULT_READY_FOR_EVENTS = true;
    public static final int DEFAULT_DURABLE_CLIENT_TIMEOUT = 300;
    private Boolean keepAlive = true;
    private Boolean readyForEvents = true;
    private Integer durableClientTimeout = 300;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String durableClientId;

    protected Class<? extends Annotation> getAnnotationType() {
        return EnableDurableClient.class;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes enableDurableClientAttributes = this.getAnnotationAttributes(importMetadata);
            this.durableClientId = enableDurableClientAttributes.containsKey((Object)"id") ? enableDurableClientAttributes.getString("id") : null;
            this.durableClientTimeout = enableDurableClientAttributes.containsKey((Object)"timeout") ? (Integer)enableDurableClientAttributes.getNumber("timeout") : Integer.valueOf(300);
            this.keepAlive = enableDurableClientAttributes.containsKey((Object)"keepAlive") ? enableDurableClientAttributes.getBoolean("keepAlive") : true;
            this.readyForEvents = enableDurableClientAttributes.containsKey((Object)"readyForEvents") ? enableDurableClientAttributes.getBoolean("readyForEvents") : true;
        }
    }

    protected Optional<String> getDurableClientId() {
        return Optional.ofNullable(this.durableClientId).filter(StringUtils::hasText);
    }

    protected Integer getDurableClientTimeout() {
        return this.durableClientTimeout != null ? this.durableClientTimeout : 300;
    }

    protected Boolean getKeepAlive() {
        return this.keepAlive != null ? this.keepAlive : true;
    }

    protected Boolean getReadyForEvents() {
        return this.readyForEvents != null ? this.readyForEvents : true;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Bean
    ClientCacheConfigurer clientCacheDurableClientConfigurer() {
        return (beanName, clientCacheFactoryBean) -> this.getDurableClientId().ifPresent(durableClientId -> {
            clientCacheFactoryBean.setDurableClientId(durableClientId);
            clientCacheFactoryBean.setDurableClientTimeout(this.getDurableClientTimeout());
            clientCacheFactoryBean.setKeepAlive(this.getKeepAlive());
            clientCacheFactoryBean.setReadyForEvents(this.getReadyForEvents());
        });
    }

    @Bean
    PeerCacheConfigurer peerCacheDurableClientConfigurer() {
        return (beanName, cacheFactoryBean) -> this.getDurableClientId().ifPresent(durableClientId -> {
            Logger logger = this.getLogger();
            if (logger.isWarnEnabled()) {
                logger.warn("Durable Client ID [{}] was set on a peer Cache instance, which will not have any effect", durableClientId);
            }
        });
    }
}

