/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.geode.config.annotation.UseDistributedSystemId;
import org.springframework.util.Assert;

@Configuration
public class DistributedSystemIdConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    private static final String GEMFIRE_DISTRIBUTED_SYSTEM_ID_PROPERTY = "distributed-system-id";
    private Integer distributedSystemId;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected Class<? extends Annotation> getAnnotationType() {
        return UseDistributedSystemId.class;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes distributedSystemIdAttributes = this.getAnnotationAttributes(importMetadata);
            this.setDistributedSystemId(distributedSystemIdAttributes.containsKey((Object)"value") ? (Integer)distributedSystemIdAttributes.getNumber("value") : null);
            this.setDistributedSystemId(distributedSystemIdAttributes.containsKey((Object)"id") ? (Integer)distributedSystemIdAttributes.getNumber("id") : null);
        }
    }

    protected void setDistributedSystemId(Integer distributedSystemId) {
        this.distributedSystemId = Optional.ofNullable(distributedSystemId).filter(id -> id > -1).orElse(this.distributedSystemId);
    }

    protected Optional<Integer> getDistributedSystemId() {
        return Optional.ofNullable(this.distributedSystemId).filter(id -> id > -1);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private int validateDistributedSystemId(int distributedSystemId) {
        Assert.isTrue((distributedSystemId >= -1 && distributedSystemId < 256 ? 1 : 0) != 0, (String)String.format("Distributed System ID [%d] must be between -1 and 255", distributedSystemId));
        return distributedSystemId;
    }

    @Bean
    ClientCacheConfigurer clientCacheDistributedSystemIdConfigurer() {
        return (beanName, clientCacheFactoryBean) -> this.getDistributedSystemId().ifPresent(distributedSystemId -> {
            Logger logger = this.getLogger();
            if (logger.isWarnEnabled()) {
                logger.warn("Distributed System Id [{}] was set on the ClientCache instance, which will not have any effect", distributedSystemId);
            }
        });
    }

    @Bean
    PeerCacheConfigurer peerCacheDistributedSystemIdConfigurer() {
        return (beanName, cacheFactoryBean) -> this.getDistributedSystemId().ifPresent(id -> cacheFactoryBean.getProperties().setProperty(GEMFIRE_DISTRIBUTED_SYSTEM_ID_PROPERTY, String.valueOf(this.validateDistributedSystemId((int)id))));
    }
}

