/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.cache;

import java.util.function.Predicate;
import org.apache.geode.cache.CacheWriter;
import org.springframework.data.gemfire.PeerRegionFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.repository.CrudRepository;
import org.springframework.geode.cache.RepositoryCacheWriter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RepositoryCacheWriterRegionConfigurer<T, ID>
implements RegionConfigurer {
    private final CrudRepository<T, ID> repository;
    private final Predicate<String> regionBeanName;

    public static <T, ID> RepositoryCacheWriterRegionConfigurer<T, ID> create(@NonNull CrudRepository<T, ID> repository, @Nullable Predicate<String> regionBeanName) {
        return new RepositoryCacheWriterRegionConfigurer<T, ID>(repository, regionBeanName);
    }

    public static <T, ID> RepositoryCacheWriterRegionConfigurer<T, ID> create(@NonNull CrudRepository<T, ID> repository, @Nullable String regionBeanName) {
        return RepositoryCacheWriterRegionConfigurer.create(repository, Predicate.isEqual(regionBeanName));
    }

    public RepositoryCacheWriterRegionConfigurer(@NonNull CrudRepository<T, ID> repository, @Nullable Predicate<String> regionBeanName) {
        Assert.notNull(repository, (String)"CrudRepository is required");
        this.repository = repository;
        this.regionBeanName = regionBeanName != null ? regionBeanName : beanName -> false;
    }

    @NonNull
    protected Predicate<String> getRegionBeanName() {
        return this.regionBeanName;
    }

    @NonNull
    protected CrudRepository<T, ID> getRepository() {
        return this.repository;
    }

    public void configure(String beanName, ClientRegionFactoryBean<?, ?> bean) {
        if (this.getRegionBeanName().test(beanName)) {
            bean.setCacheWriter((CacheWriter)this.newRepositoryCacheWriter());
        }
    }

    public void configure(String beanName, PeerRegionFactoryBean<?, ?> bean) {
        if (this.getRegionBeanName().test(beanName)) {
            bean.setCacheWriter((CacheWriter)this.newRepositoryCacheWriter());
        }
    }

    protected RepositoryCacheWriter newRepositoryCacheWriter() {
        return new RepositoryCacheWriter<T, ID>(this.getRepository());
    }
}

