/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelProcessor;
import org.springframework.util.ClassUtils;

public class PersistentEntityResourceProcessor
implements RepresentationModelProcessor<PersistentEntityResource> {
    private final List<DomainTypeResourceProcessor> resourceProcessors = new ArrayList<DomainTypeResourceProcessor>();

    @Autowired
    public PersistentEntityResourceProcessor(Repositories repositories, List<RepresentationModelProcessor<EntityModel<?>>> resourceProcessors) {
        if (null != resourceProcessors) {
            for (RepresentationModelProcessor<EntityModel<?>> rp : resourceProcessors) {
                ClassTypeInformation typeInfo = ClassTypeInformation.from(rp.getClass());
                TypeInformation domainType = (TypeInformation)typeInfo.getTypeArguments().get(0);
                if (null == repositories.getPersistentEntity(domainType.getType())) continue;
                this.resourceProcessors.add(new DomainTypeResourceProcessor(domainType.getType(), rp));
            }
        }
    }

    public PersistentEntityResource process(PersistentEntityResource resource) {
        Object content = resource.getContent();
        if (null == content) {
            return resource;
        }
        Class<?> domainType = content.getClass();
        for (DomainTypeResourceProcessor rp : this.resourceProcessors) {
            if (!ClassUtils.isAssignable(domainType, rp.domainType)) continue;
            rp.resourceProcessor.process((RepresentationModel)resource);
        }
        return resource;
    }

    private static class DomainTypeResourceProcessor {
        final Class<?> domainType;
        final RepresentationModelProcessor<EntityModel<?>> resourceProcessor;

        private DomainTypeResourceProcessor(Class<?> domainType, RepresentationModelProcessor<EntityModel<?>> resourceProcessor) {
            this.domainType = domainType;
            this.resourceProcessor = resourceProcessor;
        }
    }
}

