/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.SpringTransactionManager;
import org.neo4j.kernel.impl.transaction.UserTransactionImpl;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.neo4j.config.NullTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.UserTransactionAdapter;

public class JtaTransactionManagerFactoryBean
implements FactoryBean<JtaTransactionManager> {
    private final JtaTransactionManager jtaTransactionManager;

    public JtaTransactionManagerFactoryBean(GraphDatabaseService gds) throws Exception {
        this.jtaTransactionManager = this.create(gds);
    }

    public JtaTransactionManager getObject() throws Exception {
        return this.jtaTransactionManager;
    }

    public Class<JtaTransactionManager> getObjectType() {
        return JtaTransactionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private JtaTransactionManager create(GraphDatabaseService gds) throws Exception {
        if (!(gds instanceof GraphDatabaseAPI)) {
            return this.createNullJtaTransactionManager();
        }
        try {
            return this.createJtaTransactionManager(gds);
        }
        catch (NoSuchMethodException e) {
            return this.createJtaTransactionManagerForOnePointSeven(gds);
        }
    }

    private JtaTransactionManager createNullJtaTransactionManager() {
        NullTransactionManager transactionManager = new NullTransactionManager();
        UserTransactionAdapter userTransaction = new UserTransactionAdapter((TransactionManager)transactionManager);
        return new JtaTransactionManager((UserTransaction)userTransaction, (TransactionManager)transactionManager);
    }

    private JtaTransactionManager createJtaTransactionManagerForOnePointSeven(GraphDatabaseService gds) throws Exception {
        TransactionManager transactionManager = this.createTransactionManagerForOnePointSeven(gds);
        UserTransaction userTransaction = this.createUserTransactionForOnePointSeven(gds);
        return new JtaTransactionManager(userTransaction, transactionManager);
    }

    private JtaTransactionManager createJtaTransactionManager(GraphDatabaseService gds) throws Exception {
        TransactionManager transactionManager = this.createTransactionManagerForOnePointEight(gds);
        UserTransaction userTransaction = this.createUserTransactionForOnePointEight(gds);
        return new JtaTransactionManager(userTransaction, transactionManager);
    }

    private TransactionManager createTransactionManagerForOnePointSeven(GraphDatabaseService gds) throws Exception {
        return (TransactionManager)this.createDynamically(SpringTransactionManager.class, GraphDatabaseService.class, gds);
    }

    private UserTransaction createUserTransactionForOnePointSeven(GraphDatabaseService gds) throws Exception {
        TransactionManager txManager = ((GraphDatabaseAPI)gds).getTxManager();
        return (UserTransaction)this.createDynamically(UserTransactionImpl.class, TransactionManager.class, txManager);
    }

    private TransactionManager createTransactionManagerForOnePointEight(GraphDatabaseService gds) throws Exception {
        return (TransactionManager)this.createDynamically(SpringTransactionManager.class, GraphDatabaseAPI.class, gds);
    }

    private UserTransaction createUserTransactionForOnePointEight(GraphDatabaseService gds) throws Exception {
        return (UserTransaction)this.createDynamically(UserTransactionImpl.class, GraphDatabaseAPI.class, gds);
    }

    private <T> T createDynamically(Class<T> requiredClass, Class<?> argumentClass, Object gds) throws Exception {
        return requiredClass.getDeclaredConstructor(argumentClass).newInstance(gds);
    }
}

