/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.util.Set;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class DataGraphBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String GRAPH_DATABASE_SERVICE = "graphDatabaseService";
    private static final String BASE_PACKAGE = "base-package";
    public static final String ASPECTJ_CONFIG = "org.springframework.data.neo4j.aspects.config.Neo4jAspectConfiguration";
    public static final String CROSS_STORE_CONFIG = "org.springframework.data.neo4j.cross_store.config.CrossStoreNeo4jConfiguration";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        BeanDefinitionBuilder configBuilder = this.createConfigurationBeanDefinition(element);
        this.setupGraphDatabase(element, context, configBuilder);
        this.setupEntityManagerFactory(element, configBuilder);
        this.setupBaseEntities(element, configBuilder);
        this.setupConfigurationClassPostProcessor(context);
        return this.getSourcedBeanDefinition(configBuilder, element, context);
    }

    private void setupBaseEntities(Element element, BeanDefinitionBuilder configBuilder) {
        Set<String> initialEntityClasses = this.getInitialEntityClasses(element);
        if (initialEntityClasses != null) {
            configBuilder.addPropertyValue("initialEntitySet", initialEntityClasses);
        }
    }

    public Set<String> getInitialEntityClasses(Element element) {
        String basePackage = element.getAttribute(BASE_PACKAGE);
        if (!StringUtils.hasText((String)basePackage)) {
            return null;
        }
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(NodeEntity.class));
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RelationshipEntity.class));
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
        ManagedSet classes = new ManagedSet();
        for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
            classes.add(candidate.getBeanClassName());
        }
        return classes;
    }

    private BeanDefinitionBuilder createConfigurationBeanDefinition(Element element) {
        BeanDefinitionBuilder configBuilder = this.createConfigBuilderByMode(element);
        configBuilder.setAutowireMode(Autowire.BY_TYPE.value());
        return configBuilder;
    }

    private BeanDefinitionBuilder createConfigBuilderByMode(Element element) {
        if (this.isModeCrossStore(element)) {
            return BeanDefinitionBuilder.rootBeanDefinition((String)CROSS_STORE_CONFIG);
        }
        if (this.isModeAspectJ()) {
            return BeanDefinitionBuilder.rootBeanDefinition((String)ASPECTJ_CONFIG);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(Neo4jConfiguration.class);
    }

    private boolean isModeCrossStore(Element element) {
        return this.isModeAspectJ() && this.isEntityManagerFactoryConfigured(element);
    }

    private boolean isModeAspectJ() {
        return ClassUtils.isPresent((String)ASPECTJ_CONFIG, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    private void setupConfigurationClassPostProcessor(ParserContext parserContext) {
        BeanDefinitionRegistry beanDefinitionRegistry = parserContext.getRegistry();
        BeanDefinitionBuilder configurationClassPostProcessor = BeanDefinitionBuilder.rootBeanDefinition(ConfigurationClassPostProcessor.class);
        BeanNameGenerator beanNameGenerator = parserContext.getReaderContext().getReader().getBeanNameGenerator();
        AbstractBeanDefinition configurationClassPostProcessorBeanDefinition = configurationClassPostProcessor.getBeanDefinition();
        String beanName = beanNameGenerator.generateBeanName((BeanDefinition)configurationClassPostProcessorBeanDefinition, beanDefinitionRegistry);
        beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)configurationClassPostProcessorBeanDefinition);
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    private void setupGraphDatabase(Element element, ParserContext context, BeanDefinitionBuilder configBuilder) {
        String graphDatabaseRef = element.getAttribute(GRAPH_DATABASE_SERVICE);
        if (!StringUtils.hasText((String)graphDatabaseRef)) {
            graphDatabaseRef = this.handleStoreDir(element, context, configBuilder);
        }
        configBuilder.addPropertyReference(GRAPH_DATABASE_SERVICE, graphDatabaseRef);
    }

    private void setupEntityManagerFactory(Element element, BeanDefinitionBuilder configBuilder) {
        if (this.isEntityManagerFactoryConfigured(element)) {
            String entityManagerFactory = element.getAttribute("entityManagerFactory");
            configBuilder.addPropertyReference("entityManagerFactory", entityManagerFactory);
        }
    }

    private boolean isEntityManagerFactoryConfigured(Element element) {
        String entityManagerFactory = element.getAttribute("entityManagerFactory");
        return StringUtils.hasText((String)entityManagerFactory);
    }

    private String handleStoreDir(Element element, ParserContext context, BeanDefinitionBuilder configBuilder) {
        String storeDir = element.getAttribute("storeDirectory");
        if (!StringUtils.hasText((String)storeDir)) {
            return null;
        }
        BeanDefinitionBuilder graphDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(EmbeddedGraphDatabase.class);
        graphDefinitionBuilder.addConstructorArgValue((Object)storeDir);
        graphDefinitionBuilder.setScope("singleton");
        graphDefinitionBuilder.setDestroyMethodName("shutdown");
        context.getRegistry().registerBeanDefinition(GRAPH_DATABASE_SERVICE, (BeanDefinition)graphDefinitionBuilder.getBeanDefinition());
        configBuilder.addPropertyReference(GRAPH_DATABASE_SERVICE, GRAPH_DATABASE_SERVICE);
        return GRAPH_DATABASE_SERVICE;
    }

    private AbstractBeanDefinition getSourcedBeanDefinition(BeanDefinitionBuilder builder, Element source, ParserContext context) {
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        definition.setSource(context.extractSource((Object)source));
        return definition;
    }
}

