/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.CannotGetMongoDbConnectionException;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoFactoryBean
implements FactoryBean<Mongo>,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    private Mongo mongo;
    private MongoOptions mongoOptions;
    private String host;
    private Integer port;
    private WriteConcern writeConcern;
    private List<ServerAddress> replicaSetSeeds;
    private List<ServerAddress> replicaPair;
    private PersistenceExceptionTranslator exceptionTranslator = new MongoExceptionTranslator();

    public void setMongoOptions(MongoOptions mongoOptions) {
        this.mongoOptions = mongoOptions;
    }

    public void setReplicaSetSeeds(ServerAddress[] replicaSetSeeds) {
        this.replicaSetSeeds = Arrays.asList(replicaSetSeeds);
    }

    public void setReplicaPair(ServerAddress[] replicaPair) {
        this.replicaPair = Arrays.asList(replicaPair);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setExceptionTranslator(PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public Mongo getObject() throws Exception {
        return this.mongo;
    }

    public Class<? extends Mongo> getObjectType() {
        return Mongo.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    public void afterPropertiesSet() throws Exception {
        Mongo mongo;
        ServerAddress defaultOptions = new ServerAddress();
        if (this.mongoOptions == null) {
            this.mongoOptions = new MongoOptions();
        }
        if (this.replicaPair != null) {
            if (this.replicaPair.size() < 2) {
                throw new CannotGetMongoDbConnectionException("A replica pair must have two server entries");
            }
            mongo = new Mongo(this.replicaPair.get(0), this.replicaPair.get(1), this.mongoOptions);
        } else if (this.replicaSetSeeds != null) {
            mongo = new Mongo(this.replicaSetSeeds, this.mongoOptions);
        } else {
            String mongoHost = this.host != null ? this.host : defaultOptions.getHost();
            Mongo mongo2 = mongo = this.port != null ? new Mongo(new ServerAddress(mongoHost, this.port.intValue()), this.mongoOptions) : new Mongo(mongoHost, this.mongoOptions);
        }
        if (this.writeConcern != null) {
            mongo.setWriteConcern(this.writeConcern);
        }
        this.mongo = mongo;
    }

    public void destroy() throws Exception {
        this.mongo.close();
    }
}

