/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Locale;
import org.bson.BSONObject;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.TextCriteria;

public class TextQuery
extends Query {
    private final String DEFAULT_SCORE_FIELD_FIELDNAME = "score";
    private final DBObject META_TEXT_SCORE = new BasicDBObject("$meta", (Object)"textScore");
    private String scoreFieldName = "score";
    private boolean includeScore = false;
    private boolean sortByScore = false;

    public TextQuery(String wordsAndPhrases) {
        super(TextCriteria.forDefaultLanguage().matching(wordsAndPhrases));
    }

    public TextQuery(String wordsAndPhrases, String language) {
        super(TextCriteria.forLanguage(language).matching(wordsAndPhrases));
    }

    public TextQuery(String wordsAndPhrases, Locale locale) {
        this(wordsAndPhrases, locale != null ? locale.getLanguage() : (String)null);
    }

    public TextQuery(TextCriteria criteria) {
        super(criteria);
    }

    public static TextQuery queryText(TextCriteria criteria) {
        return new TextQuery(criteria);
    }

    public TextQuery sortByScore() {
        this.includeScore();
        this.sortByScore = true;
        return this;
    }

    public TextQuery includeScore() {
        this.includeScore = true;
        return this;
    }

    public TextQuery includeScore(String fieldname) {
        this.setScoreFieldName(fieldname);
        this.includeScore();
        return this;
    }

    public void setScoreFieldName(String fieldName) {
        this.scoreFieldName = fieldName;
    }

    public String getScoreFieldName() {
        return this.scoreFieldName;
    }

    @Override
    public DBObject getFieldsObject() {
        if (!this.includeScore) {
            return super.getFieldsObject();
        }
        DBObject fields = super.getFieldsObject();
        if (fields == null) {
            fields = new BasicDBObject();
        }
        fields.put(this.getScoreFieldName(), (Object)this.META_TEXT_SCORE);
        return fields;
    }

    @Override
    public DBObject getSortObject() {
        BasicDBObject sort = new BasicDBObject();
        if (this.sortByScore) {
            sort.put(this.getScoreFieldName(), (Object)this.META_TEXT_SCORE);
        }
        if (super.getSortObject() != null) {
            sort.putAll((BSONObject)super.getSortObject());
        }
        return sort;
    }
}

