/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.Assert;

public class GroupByResults<T>
implements Iterable<T> {
    private final List<T> mappedResults;
    private final DBObject rawResults;
    private double count;
    private int keys;
    private String serverUsed;

    public GroupByResults(List<T> mappedResults, DBObject rawResults) {
        Assert.notNull(mappedResults, (String)"List of mapped results must not be null!");
        Assert.notNull((Object)rawResults, (String)"Raw results must not be null!");
        this.mappedResults = mappedResults;
        this.rawResults = rawResults;
        this.parseKeys();
        this.parseCount();
        this.parseServerUsed();
    }

    public double getCount() {
        return this.count;
    }

    public int getKeys() {
        return this.keys;
    }

    public String getServerUsed() {
        return this.serverUsed;
    }

    @Override
    public Iterator<T> iterator() {
        return this.mappedResults.iterator();
    }

    public DBObject getRawResults() {
        return this.rawResults;
    }

    private void parseCount() {
        Object object = this.rawResults.get("count");
        if (object instanceof Number) {
            this.count = ((Number)object).doubleValue();
        }
    }

    private void parseKeys() {
        Object object = this.rawResults.get("keys");
        if (object instanceof Number) {
            this.keys = ((Number)object).intValue();
        }
    }

    private void parseServerUsed() {
        Object object = this.rawResults.get("serverUsed");
        if (object instanceof String) {
            this.serverUsed = (String)object;
        }
    }
}

