/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexDefinition;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexed;
import org.springframework.data.mongodb.core.index.GeospatialIndex;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexDirection;
import org.springframework.data.mongodb.core.index.IndexResolver;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.index.TextIndexDefinition;
import org.springframework.data.mongodb.core.index.TextIndexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MongoPersistentEntityIndexResolver
implements IndexResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoPersistentEntityIndexResolver.class);
    private final MongoMappingContext mappingContext;

    public MongoPersistentEntityIndexResolver(MongoMappingContext mappingContext) {
        Assert.notNull((Object)((Object)mappingContext), (String)"Mapping context must not be null in order to resolve index definitions");
        this.mappingContext = mappingContext;
    }

    @Override
    public Iterable<? extends IndexDefinitionHolder> resolveIndexFor(TypeInformation<?> typeInformation) {
        return this.resolveIndexForEntity((MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeInformation));
    }

    public List<IndexDefinitionHolder> resolveIndexForEntity(final MongoPersistentEntity<?> root) {
        Assert.notNull(root, (String)"Index cannot be resolved for given 'null' entity.");
        Document document = (Document)root.findAnnotation(Document.class);
        Assert.notNull((Object)document, (String)"Given entity is not collection root.");
        final ArrayList<IndexDefinitionHolder> indexInformation = new ArrayList<IndexDefinitionHolder>();
        indexInformation.addAll(this.potentiallyCreateCompoundIndexDefinitions("", root.getCollection(), root));
        indexInformation.addAll(this.potentiallyCreateTextIndexDefinition(root));
        final CycleGuard guard = new CycleGuard();
        root.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
                try {
                    IndexDefinitionHolder indexDefinitionHolder;
                    if (persistentProperty.isEntity()) {
                        indexInformation.addAll(MongoPersistentEntityIndexResolver.this.resolveIndexForClass(persistentProperty.getTypeInformation().getActualType(), persistentProperty.getFieldName(), CycleGuard.Path.of(persistentProperty), root.getCollection(), guard));
                    }
                    if ((indexDefinitionHolder = MongoPersistentEntityIndexResolver.this.createIndexDefinitionHolderForProperty(persistentProperty.getFieldName(), root.getCollection(), persistentProperty)) != null) {
                        indexInformation.add(indexDefinitionHolder);
                    }
                }
                catch (CyclicPropertyReferenceException e) {
                    LOGGER.info(e.getMessage());
                }
            }
        });
        indexInformation.addAll(this.resolveIndexesForDbrefs("", root.getCollection(), root));
        return indexInformation;
    }

    private List<IndexDefinitionHolder> resolveIndexForClass(TypeInformation<?> type, final String dotPath, final CycleGuard.Path path, final String collection, final CycleGuard guard) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
        final ArrayList<IndexDefinitionHolder> indexInformation = new ArrayList<IndexDefinitionHolder>();
        indexInformation.addAll(this.potentiallyCreateCompoundIndexDefinitions(dotPath, collection, entity));
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
                IndexDefinitionHolder indexDefinitionHolder;
                String propertyDotPath = (StringUtils.hasText((String)dotPath) ? dotPath + "." : "") + persistentProperty.getFieldName();
                CycleGuard.Path propertyPath = path.append(persistentProperty);
                guard.protect(persistentProperty, propertyPath);
                if (persistentProperty.isEntity()) {
                    try {
                        indexInformation.addAll(MongoPersistentEntityIndexResolver.this.resolveIndexForClass(persistentProperty.getTypeInformation().getActualType(), propertyDotPath, propertyPath, collection, guard));
                    }
                    catch (CyclicPropertyReferenceException e) {
                        LOGGER.info(e.getMessage());
                    }
                }
                if ((indexDefinitionHolder = MongoPersistentEntityIndexResolver.this.createIndexDefinitionHolderForProperty(propertyDotPath, collection, persistentProperty)) != null) {
                    indexInformation.add(indexDefinitionHolder);
                }
            }
        });
        indexInformation.addAll(this.resolveIndexesForDbrefs(dotPath, collection, entity));
        return indexInformation;
    }

    private IndexDefinitionHolder createIndexDefinitionHolderForProperty(String dotPath, String collection, MongoPersistentProperty persistentProperty) {
        if (persistentProperty.isAnnotationPresent(Indexed.class)) {
            return this.createIndexDefinition(dotPath, collection, persistentProperty);
        }
        if (persistentProperty.isAnnotationPresent(GeoSpatialIndexed.class)) {
            return this.createGeoSpatialIndexDefinition(dotPath, collection, persistentProperty);
        }
        return null;
    }

    private List<IndexDefinitionHolder> potentiallyCreateCompoundIndexDefinitions(String dotPath, String collection, MongoPersistentEntity<?> entity) {
        if (entity.findAnnotation(CompoundIndexes.class) == null && entity.findAnnotation(CompoundIndex.class) == null) {
            return Collections.emptyList();
        }
        return this.createCompoundIndexDefinitions(dotPath, collection, entity);
    }

    private Collection<? extends IndexDefinitionHolder> potentiallyCreateTextIndexDefinition(MongoPersistentEntity<?> root) {
        TextIndexDefinition.TextIndexDefinitionBuilder indexDefinitionBuilder = new TextIndexDefinition.TextIndexDefinitionBuilder().named(root.getType().getSimpleName() + "_TextIndex");
        if (StringUtils.hasText((String)root.getLanguage())) {
            indexDefinitionBuilder.withDefaultLanguage(root.getLanguage());
        }
        try {
            this.appendTextIndexInformation("", CycleGuard.Path.empty(), indexDefinitionBuilder, root, new TextIndexIncludeOptions(TextIndexIncludeOptions.IncludeStrategy.DEFAULT), new CycleGuard());
        }
        catch (CyclicPropertyReferenceException e) {
            LOGGER.info(e.getMessage());
        }
        TextIndexDefinition indexDefinition = indexDefinitionBuilder.build();
        if (!indexDefinition.hasFieldSpec()) {
            return Collections.emptyList();
        }
        IndexDefinitionHolder holder = new IndexDefinitionHolder("", indexDefinition, root.getCollection());
        return Collections.singletonList(holder);
    }

    private void appendTextIndexInformation(final String dotPath, final CycleGuard.Path path, final TextIndexDefinition.TextIndexDefinitionBuilder indexDefinitionBuilder, final MongoPersistentEntity<?> entity, final TextIndexIncludeOptions includeOptions, final CycleGuard guard) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
                guard.protect(persistentProperty, path);
                if (persistentProperty.isExplicitLanguageProperty() && !StringUtils.hasText((String)dotPath)) {
                    indexDefinitionBuilder.withLanguageOverride(persistentProperty.getFieldName());
                }
                TextIndexed indexed = (TextIndexed)persistentProperty.findAnnotation(TextIndexed.class);
                if (includeOptions.isForce() || indexed != null || persistentProperty.isEntity()) {
                    String propertyDotPath = (StringUtils.hasText((String)dotPath) ? dotPath + "." : "") + persistentProperty.getFieldName();
                    CycleGuard.Path propertyPath = path.append(persistentProperty);
                    Float weight = Float.valueOf(indexed != null ? indexed.weight() : (includeOptions.getParentFieldSpec() != null ? includeOptions.getParentFieldSpec().getWeight().floatValue() : 1.0f));
                    if (persistentProperty.isEntity()) {
                        TextIndexIncludeOptions optionsForNestedType = includeOptions;
                        if (!TextIndexIncludeOptions.IncludeStrategy.FORCE.equals((Object)includeOptions.getStrategy()) && indexed != null) {
                            optionsForNestedType = new TextIndexIncludeOptions(TextIndexIncludeOptions.IncludeStrategy.FORCE, new TextIndexDefinition.TextIndexedFieldSpec(propertyDotPath, weight));
                        }
                        try {
                            MongoPersistentEntityIndexResolver.this.appendTextIndexInformation(propertyDotPath, propertyPath, indexDefinitionBuilder, (MongoPersistentEntity)MongoPersistentEntityIndexResolver.this.mappingContext.getPersistentEntity(persistentProperty.getActualType()), optionsForNestedType, guard);
                        }
                        catch (CyclicPropertyReferenceException e) {
                            LOGGER.info(e.getMessage());
                        }
                        catch (InvalidDataAccessApiUsageException e) {
                            LOGGER.info(String.format("Potentially invalid index structure discovered. Breaking operation for %s.", entity.getName()), (Throwable)e);
                        }
                    } else if (includeOptions.isForce() || indexed != null) {
                        indexDefinitionBuilder.onField(propertyDotPath, weight);
                    }
                }
            }
        });
    }

    protected List<IndexDefinitionHolder> createCompoundIndexDefinitions(String dotPath, String fallbackCollection, MongoPersistentEntity<?> entity) {
        CompoundIndex index;
        ArrayList<IndexDefinitionHolder> indexDefinitions = new ArrayList<IndexDefinitionHolder>();
        CompoundIndexes indexes = (CompoundIndexes)entity.findAnnotation(CompoundIndexes.class);
        if (indexes != null) {
            for (CompoundIndex index2 : indexes.value()) {
                indexDefinitions.add(this.createCompoundIndexDefinition(dotPath, fallbackCollection, index2, entity));
            }
        }
        if ((index = (CompoundIndex)entity.findAnnotation(CompoundIndex.class)) != null) {
            indexDefinitions.add(this.createCompoundIndexDefinition(dotPath, fallbackCollection, index, entity));
        }
        return indexDefinitions;
    }

    protected IndexDefinitionHolder createCompoundIndexDefinition(String dotPath, String fallbackCollection, CompoundIndex index, MongoPersistentEntity<?> entity) {
        CompoundIndexDefinition indexDefinition = new CompoundIndexDefinition(this.resolveCompoundIndexKeyFromStringDefinition(dotPath, index.def()));
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, null));
        }
        if (index.unique()) {
            indexDefinition.unique(index.dropDups() ? Index.Duplicates.DROP : Index.Duplicates.RETAIN);
        }
        if (index.sparse()) {
            indexDefinition.sparse();
        }
        if (index.background()) {
            indexDefinition.background();
        }
        String collection = StringUtils.hasText((String)index.collection()) ? index.collection() : fallbackCollection;
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    private DBObject resolveCompoundIndexKeyFromStringDefinition(String dotPath, String keyDefinitionString) {
        if (!StringUtils.hasText((String)dotPath) && !StringUtils.hasText((String)keyDefinitionString)) {
            throw new InvalidDataAccessApiUsageException("Cannot create index on root level for empty keys.");
        }
        if (!StringUtils.hasText((String)keyDefinitionString)) {
            return new BasicDBObject(dotPath, (Object)1);
        }
        DBObject dbo = (DBObject)JSON.parse((String)keyDefinitionString);
        if (!StringUtils.hasText((String)dotPath)) {
            return dbo;
        }
        BasicDBObjectBuilder dboBuilder = new BasicDBObjectBuilder();
        for (String key : dbo.keySet()) {
            dboBuilder.add(dotPath + "." + key, dbo.get(key));
        }
        return dboBuilder.get();
    }

    protected IndexDefinitionHolder createIndexDefinition(String dotPath, String fallbackCollection, MongoPersistentProperty persitentProperty) {
        Indexed index = (Indexed)persitentProperty.findAnnotation(Indexed.class);
        String collection = StringUtils.hasText((String)index.collection()) ? index.collection() : fallbackCollection;
        Index indexDefinition = new Index().on(dotPath, IndexDirection.ASCENDING.equals((Object)index.direction()) ? Sort.Direction.ASC : Sort.Direction.DESC);
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, persitentProperty));
        }
        if (index.unique()) {
            indexDefinition.unique(index.dropDups() ? Index.Duplicates.DROP : Index.Duplicates.RETAIN);
        }
        if (index.sparse()) {
            indexDefinition.sparse();
        }
        if (index.background()) {
            indexDefinition.background();
        }
        if (index.expireAfterSeconds() >= 0) {
            indexDefinition.expire(index.expireAfterSeconds(), TimeUnit.SECONDS);
        }
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    protected IndexDefinitionHolder createGeoSpatialIndexDefinition(String dotPath, String fallbackCollection, MongoPersistentProperty persistentProperty) {
        GeoSpatialIndexed index = (GeoSpatialIndexed)persistentProperty.findAnnotation(GeoSpatialIndexed.class);
        String collection = StringUtils.hasText((String)index.collection()) ? index.collection() : fallbackCollection;
        GeospatialIndex indexDefinition = new GeospatialIndex(dotPath);
        indexDefinition.withBits(index.bits());
        indexDefinition.withMin(index.min()).withMax(index.max());
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, persistentProperty));
        }
        indexDefinition.typed(index.type()).withBucketSize(index.bucketSize()).withAdditionalField(index.additionalField());
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    private String pathAwareIndexName(String indexName, String dotPath, MongoPersistentProperty property) {
        String nameToUse;
        String string = nameToUse = StringUtils.hasText((String)indexName) ? indexName : "";
        if (!StringUtils.hasText((String)dotPath) || property != null && dotPath.equals(property.getFieldName())) {
            return StringUtils.hasText((String)nameToUse) ? nameToUse : dotPath;
        }
        if (StringUtils.hasText((String)dotPath)) {
            nameToUse = StringUtils.hasText((String)nameToUse) ? (property != null ? dotPath.replace("." + property.getFieldName(), "") : dotPath) + "." + nameToUse : dotPath;
        }
        return nameToUse;
    }

    private List<IndexDefinitionHolder> resolveIndexesForDbrefs(final String path, final String collection, MongoPersistentEntity<?> entity) {
        final ArrayList<IndexDefinitionHolder> indexes = new ArrayList<IndexDefinitionHolder>(0);
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                MongoPersistentProperty property = (MongoPersistentProperty)association.getInverse();
                String propertyDotPath = (StringUtils.hasText((String)path) ? path + "." : "") + property.getFieldName();
                if (property.isAnnotationPresent(GeoSpatialIndexed.class) || property.isAnnotationPresent(TextIndexed.class)) {
                    throw new MappingException(String.format("Cannot create geospatial-/text- index on DBRef in collection '%s' for path '%s'.", collection, propertyDotPath));
                }
                IndexDefinitionHolder indexDefinitionHolder = MongoPersistentEntityIndexResolver.this.createIndexDefinitionHolderForProperty(propertyDotPath, collection, property);
                if (indexDefinitionHolder != null) {
                    indexes.add(indexDefinitionHolder);
                }
            }
        });
        return indexes;
    }

    static class TextIndexIncludeOptions {
        private final IncludeStrategy strategy;
        private final TextIndexDefinition.TextIndexedFieldSpec parentFieldSpec;

        public TextIndexIncludeOptions(IncludeStrategy strategy, TextIndexDefinition.TextIndexedFieldSpec parentFieldSpec) {
            this.strategy = strategy;
            this.parentFieldSpec = parentFieldSpec;
        }

        public TextIndexIncludeOptions(IncludeStrategy strategy) {
            this(strategy, null);
        }

        public IncludeStrategy getStrategy() {
            return this.strategy;
        }

        public TextIndexDefinition.TextIndexedFieldSpec getParentFieldSpec() {
            return this.parentFieldSpec;
        }

        public boolean isForce() {
            return IncludeStrategy.FORCE.equals((Object)this.strategy);
        }

        static enum IncludeStrategy {
            FORCE,
            DEFAULT;

        }
    }

    public static class IndexDefinitionHolder
    implements IndexDefinition {
        private final String path;
        private final IndexDefinition indexDefinition;
        private final String collection;

        public IndexDefinitionHolder(String path, IndexDefinition definition, String collection) {
            this.path = path;
            this.indexDefinition = definition;
            this.collection = collection;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getPath() {
            return this.path;
        }

        public IndexDefinition getIndexDefinition() {
            return this.indexDefinition;
        }

        @Override
        public DBObject getIndexKeys() {
            return this.indexDefinition.getIndexKeys();
        }

        @Override
        public DBObject getIndexOptions() {
            return this.indexDefinition.getIndexOptions();
        }
    }

    public static class CyclicPropertyReferenceException
    extends RuntimeException {
        private static final long serialVersionUID = -3762979307658772277L;
        private final String propertyName;
        private final Class<?> type;
        private final String dotPath;

        public CyclicPropertyReferenceException(String propertyName, Class<?> type, String dotPath) {
            this.propertyName = propertyName;
            this.type = type;
            this.dotPath = dotPath;
        }

        @Override
        public String getMessage() {
            return String.format("Found cycle for field '%s' in type '%s' for path '%s'", this.propertyName, this.type != null ? this.type.getSimpleName() : "unknown", this.dotPath);
        }
    }

    static class CycleGuard {
        private final Set<String> seenProperties = new HashSet<String>();

        CycleGuard() {
        }

        void protect(MongoPersistentProperty property, Path path) throws CyclicPropertyReferenceException {
            String propertyTypeKey = this.createMapKey(property);
            if (!this.seenProperties.add(propertyTypeKey) && path.isCycle()) {
                throw new CyclicPropertyReferenceException(property.getFieldName(), property.getOwner().getType(), path.toCyclePath());
            }
        }

        private String createMapKey(MongoPersistentProperty property) {
            return ClassUtils.getShortName((Class)property.getOwner().getType()) + ":" + property.getFieldName();
        }

        static class Path {
            private static final Path EMPTY = new Path(Collections.<PersistentProperty<?>>emptyList(), false);
            private final List<PersistentProperty<?>> elements;
            private final boolean cycle;

            static Path empty() {
                return EMPTY;
            }

            static Path of(PersistentProperty<?> initial) {
                return new Path(Collections.singletonList(initial), false);
            }

            Path append(PersistentProperty<?> breadcrumb) {
                ArrayList elements = new ArrayList(this.elements.size() + 1);
                elements.addAll(this.elements);
                elements.add(breadcrumb);
                return new Path(elements, this.elements.contains(breadcrumb));
            }

            public boolean isCycle() {
                return this.cycle;
            }

            public String toString() {
                return this.elements.isEmpty() ? "(empty)" : Path.toPath(this.elements.iterator());
            }

            String toCyclePath() {
                if (!this.cycle) {
                    return "";
                }
                for (int i = 0; i < this.elements.size(); ++i) {
                    int index = Path.indexOf(this.elements, this.elements.get(i), i + 1);
                    if (index == -1) continue;
                    return Path.toPath(this.elements.subList(i, index + 1).iterator());
                }
                return this.toString();
            }

            private static <T> int indexOf(List<T> haystack, T needle, int offset) {
                for (int i = offset; i < haystack.size(); ++i) {
                    if (!haystack.get(i).equals(needle)) continue;
                    return i;
                }
                return -1;
            }

            private static String toPath(Iterator<PersistentProperty<?>> iterator) {
                StringBuilder builder = new StringBuilder();
                while (iterator.hasNext()) {
                    builder.append(iterator.next().getName());
                    if (!iterator.hasNext()) continue;
                    builder.append(" -> ");
                }
                return builder.toString();
            }

            @ConstructorProperties(value={"elements", "cycle"})
            private Path(List<PersistentProperty<?>> elements, boolean cycle) {
                this.elements = elements;
                this.cycle = cycle;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Path)) {
                    return false;
                }
                Path other = (Path)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<PersistentProperty<?>> this$elements = this.elements;
                List<PersistentProperty<?>> other$elements = other.elements;
                if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
                    return false;
                }
                return this.isCycle() == other.isCycle();
            }

            protected boolean canEqual(Object other) {
                return other instanceof Path;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<PersistentProperty<?>> $elements = this.elements;
                result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
                result = result * 59 + (this.isCycle() ? 79 : 97);
                return result;
            }
        }
    }
}

