/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.Metric;
import org.springframework.data.mongodb.core.geo.Metrics;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;

public class NearQuery {
    private final DBObject criteria;
    private Query query;
    private Double maxDistance;
    private Metric metric;

    private NearQuery(Point point, Metric metric) {
        Assert.notNull((Object)point);
        this.criteria = new BasicDBObject();
        this.criteria.put("near", point.asList());
        this.metric = metric;
        if (metric != null) {
            this.spherical(true);
            this.distanceMultiplier(metric);
        }
    }

    public static NearQuery near(double x, double y) {
        return NearQuery.near(x, y, null);
    }

    public static NearQuery near(double x, double y, Metric metric) {
        return NearQuery.near(new Point(x, y), metric);
    }

    public static NearQuery near(Point point) {
        return NearQuery.near(point, null);
    }

    public static NearQuery near(Point point, Metric metric) {
        Assert.notNull((Object)point);
        return new NearQuery(point, metric);
    }

    public Metric getMetric() {
        return this.metric;
    }

    public NearQuery num(int num) {
        this.criteria.put("num", (Object)num);
        return this;
    }

    public NearQuery maxDistance(double maxDistance) {
        this.maxDistance = this.getNormalizedDistance(maxDistance, this.metric);
        return this;
    }

    public NearQuery maxDistance(double maxDistance, Metric metric) {
        Assert.notNull((Object)metric);
        this.spherical(true);
        return this.maxDistance(this.getNormalizedDistance(maxDistance, metric));
    }

    public NearQuery maxDistance(Distance distance) {
        Assert.notNull((Object)distance);
        return this.maxDistance(distance.getValue(), distance.getMetric());
    }

    public NearQuery distanceMultiplier(double distanceMultiplier) {
        this.criteria.put("distanceMultiplier", (Object)distanceMultiplier);
        return this;
    }

    public NearQuery distanceMultiplier(Metric metric) {
        Assert.notNull((Object)metric);
        return this.distanceMultiplier(metric.getMultiplier());
    }

    public NearQuery spherical(boolean spherical) {
        this.criteria.put("spherical", (Object)spherical);
        return this;
    }

    public NearQuery inKilometers() {
        return this.adaptMetric(Metrics.KILOMETERS);
    }

    public NearQuery inMiles() {
        return this.adaptMetric(Metrics.MILES);
    }

    private NearQuery adaptMetric(Metric metric) {
        if (this.metric == null && this.maxDistance != null) {
            this.maxDistance(this.maxDistance, metric);
        }
        this.spherical(true);
        return this.distanceMultiplier(metric);
    }

    public NearQuery query(Query query) {
        this.query = query;
        return this;
    }

    public DBObject toDBObject() {
        BasicDBObject dbObject = new BasicDBObject(this.criteria.toMap());
        if (this.query != null) {
            dbObject.put("query", (Object)this.query.getQueryObject());
        }
        if (this.maxDistance != null) {
            dbObject.put("maxDistance", (Object)this.maxDistance);
        }
        return dbObject;
    }

    private double getNormalizedDistance(double distance, Metric metric) {
        return metric == null ? distance : distance / metric.getMultiplier();
    }
}

