/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultQueryEnhancer;
import org.springframework.data.jpa.repository.query.JSqlParserQueryEnhancer;
import org.springframework.data.jpa.repository.query.JpaQueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancerFactory;
import org.springframework.data.jpa.repository.query.QueryProvider;
import org.springframework.util.ClassUtils;

public class QueryEnhancerFactories {
    private static final Log LOG = LogFactory.getLog(QueryEnhancerFactories.class);
    static final boolean jSqlParserPresent = ClassUtils.isPresent((String)"net.sf.jsqlparser.parser.JSqlParser", (ClassLoader)QueryEnhancerFactory.class.getClassLoader());

    static {
        if (jSqlParserPresent) {
            LOG.info((Object)"JSqlParser is in classpath; If applicable, JSqlParser will be used");
        }
        if (PersistenceProvider.ECLIPSELINK.isPresent()) {
            LOG.info((Object)"EclipseLink is in classpath; If applicable, EQL parser will be used.");
        }
        if (PersistenceProvider.HIBERNATE.isPresent()) {
            LOG.info((Object)"Hibernate is in classpath; If applicable, HQL parser will be used.");
        }
    }

    public static QueryEnhancerFactory fallback() {
        return BuiltinQueryEnhancerFactories.FALLBACK;
    }

    public static QueryEnhancerFactory jsqlparser() {
        if (!jSqlParserPresent) {
            throw new IllegalStateException("JSQLParser is not available on the class path");
        }
        return BuiltinQueryEnhancerFactories.JSQLPARSER;
    }

    public static QueryEnhancerFactory hql() {
        return BuiltinQueryEnhancerFactories.HQL;
    }

    public static QueryEnhancerFactory eql() {
        return BuiltinQueryEnhancerFactories.EQL;
    }

    public static QueryEnhancerFactory jpql() {
        return BuiltinQueryEnhancerFactories.JPQL;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum BuiltinQueryEnhancerFactories implements QueryEnhancerFactory
    {
        FALLBACK{

            @Override
            public boolean supports(DeclaredQuery query) {
                return true;
            }

            @Override
            public QueryEnhancer create(QueryProvider query) {
                return new DefaultQueryEnhancer(query);
            }
        }
        ,
        JSQLPARSER{

            @Override
            public boolean supports(DeclaredQuery query) {
                return query.isNative();
            }

            @Override
            public QueryEnhancer create(QueryProvider query) {
                if (jSqlParserPresent) {
                    return new JSqlParserQueryEnhancer(query);
                }
                throw new IllegalStateException("JSQLParser is not available on the class path");
            }
        }
        ,
        HQL{

            @Override
            public boolean supports(DeclaredQuery query) {
                return query.isJpql();
            }

            @Override
            public QueryEnhancer create(QueryProvider query) {
                return JpaQueryEnhancer.forHql(query.getQueryString());
            }
        }
        ,
        EQL{

            @Override
            public boolean supports(DeclaredQuery query) {
                return query.isJpql();
            }

            @Override
            public QueryEnhancer create(QueryProvider query) {
                return JpaQueryEnhancer.forEql(query.getQueryString());
            }
        }
        ,
        JPQL{

            @Override
            public boolean supports(DeclaredQuery query) {
                return query.isJpql();
            }

            @Override
            public QueryEnhancer create(QueryProvider query) {
                return JpaQueryEnhancer.forJpql(query.getQueryString());
            }
        };

    }
}

