/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.springframework.data.util.Predicates;
import org.springframework.data.util.TypeCollector;
import org.springframework.data.util.TypeUtils;

class JpaTypeFilters
implements TypeCollector.TypeCollectorFilters {
    private static final Predicate<Member> IS_HIBERNATE_MEMBER = member -> member.getName().startsWith("$$_hibernate");
    private static final Predicate<Class<?>> CLASS_FILTER = it -> TypeUtils.type((Class)it).isPartOf(new String[]{"org.hibernate", "org.eclipse.persistence", "jakarta.persistence"});

    JpaTypeFilters() {
    }

    public Predicate<Class<?>> classPredicate() {
        return CLASS_FILTER.negate();
    }

    public Predicate<Field> fieldPredicate() {
        return Predicates.declaringClass(CLASS_FILTER).or(IS_HIBERNATE_MEMBER).negate();
    }

    public Predicate<Method> methodPredicate() {
        return Predicates.declaringClass(CLASS_FILTER).or(IS_HIBERNATE_MEMBER).negate();
    }
}

