/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import jakarta.persistence.metamodel.Metamodel;
import java.util.Set;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.jpa.mapping.JpaPersistentEntityImpl;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.mapping.JpaPersistentPropertyImpl;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.mapping.PersistentPropertyPaths;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;

public class JpaMetamodelMappingContext
extends AbstractMappingContext<JpaPersistentEntityImpl<?>, JpaPersistentProperty> {
    private final Metamodels models;
    private final PersistenceProvider persistenceProvider;

    public JpaMetamodelMappingContext(Set<Metamodel> models) {
        Assert.notEmpty(models, (String)"JPA metamodel must not be empty");
        this.models = new Metamodels(models);
        this.persistenceProvider = PersistenceProvider.fromMetamodel(models.iterator().next());
    }

    protected <T> JpaPersistentEntityImpl<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new JpaPersistentEntityImpl<T>(typeInformation, this.persistenceProvider, this.models.getRequiredMetamodel(typeInformation));
    }

    protected JpaPersistentProperty createPersistentProperty(Property property, JpaPersistentEntityImpl<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new JpaPersistentPropertyImpl(owner.getMetamodel(), property, owner, simpleTypeHolder);
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        return this.models.isMetamodelManagedType(type.getUserTypeInformation());
    }

    public <T> PersistentPropertyPaths<T, JpaPersistentProperty> findPersistentPropertyPaths(Class<T> type, Predicate<? super JpaPersistentProperty> predicate) {
        return this.doFindPersistentPropertyPaths(type, predicate, JpaPersistentProperty::isEmbeddable);
    }

    public boolean hasPersistentEntityFor(Class<?> type) {
        return super.hasPersistentEntityFor(type) || this.models.isMetamodelManagedType(type);
    }

    private static class Metamodels {
        private final Set<Metamodel> metamodels;

        private Metamodels(Set<Metamodel> metamodels) {
            this.metamodels = metamodels;
        }

        @Nullable
        public JpaMetamodel getMetamodel(TypeInformation<?> type) {
            Metamodel metamodel = this.getMetamodelFor(type.getType());
            return metamodel == null ? null : JpaMetamodel.of(metamodel);
        }

        public JpaMetamodel getRequiredMetamodel(TypeInformation<?> type) {
            JpaMetamodel metamodel = this.getMetamodel(type);
            Assert.notNull((Object)metamodel, () -> String.format("Required JpaMetamodel not found for %s", type));
            return metamodel;
        }

        public boolean isMetamodelManagedType(TypeInformation<?> type) {
            return this.isMetamodelManagedType(type.getType());
        }

        public boolean isMetamodelManagedType(Class<?> type) {
            return this.getMetamodelFor(type) != null;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        private Metamodel getMetamodelFor(Class<?> type) {
            block2: for (Metamodel model : this.metamodels) {
                try {
                    model.managedType(type);
                    return model;
                }
                catch (IllegalArgumentException v0) {
                    ** for (managedType : model.getManagedTypes())
                }
lbl-1000:
                // 1 sources

                {
                    if (!type.equals(managedType.getJavaType())) continue;
                    return model;
lbl10:
                    // 1 sources

                }
            }
            return null;
        }
    }
}

