/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.domain.SearchResult;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SearchResults<T>
implements Iterable<SearchResult<T>>,
Serializable {
    private final List<? extends SearchResult<T>> results;

    public SearchResults(List<? extends SearchResult<T>> results) {
        this.results = results;
    }

    public List<SearchResult<T>> getContent() {
        return Collections.unmodifiableList(this.results);
    }

    @Override
    public Iterator<SearchResult<T>> iterator() {
        return this.results.iterator();
    }

    public Stream<SearchResult<T>> stream() {
        return Streamable.of(this).stream();
    }

    public Stream<T> contentStream() {
        return this.getContent().stream().map(SearchResult::getContent);
    }

    public <U> SearchResults<U> map(Function<? super T, ? extends U> converter) {
        Assert.notNull(converter, (String)"Function must not be null");
        List result = this.results.stream().map((? super T it) -> it.map(converter)).collect(Collectors.toList());
        return new SearchResults<T>(result);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchResults)) {
            return false;
        }
        SearchResults that = (SearchResults)o;
        return ObjectUtils.nullSafeEquals(this.results, that.results);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.results);
    }

    public String toString() {
        return this.results.isEmpty() ? "SearchResults [empty]" : String.format("SearchResults [size: %s]", this.results.size());
    }
}

