/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.data.web.config.ProjectingArgumentResolverRegistrar;
import org.springframework.data.web.config.QuerydslWebConfiguration;
import org.springframework.data.web.config.SpringDataJacksonModules;
import org.springframework.data.web.config.SpringDataWebConfiguration;
import org.springframework.util.ClassUtils;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@Inherited
@Import(value={SpringDataWebConfigurationImportSelector.class, QuerydslActivator.class})
public @interface EnableSpringDataWebSupport {

    public static class QuerydslActivator
    implements ImportSelector {
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            String[] stringArray;
            if (QueryDslUtils.QUERY_DSL_PRESENT) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = QuerydslWebConfiguration.class.getName();
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
    }

    public static class SpringDataWebConfigurationImportSelector
    implements ImportSelector,
    EnvironmentAware,
    ResourceLoaderAware {
        private Environment environment;
        private ResourceLoader resourceLoader;

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            ArrayList<String> imports = new ArrayList<String>();
            imports.add(ProjectingArgumentResolverRegistrar.class.getName());
            imports.add(ClassUtils.isPresent((String)"org.springframework.hateoas.Link", (ClassLoader)this.resourceLoader.getClassLoader()) ? HateoasAwareSpringDataWebConfiguration.class.getName() : SpringDataWebConfiguration.class.getName());
            if (ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)this.resourceLoader.getClassLoader())) {
                imports.addAll(SpringFactoriesLoader.loadFactoryNames(SpringDataJacksonModules.class, (ClassLoader)this.resourceLoader.getClassLoader()));
            }
            return imports.toArray(new String[imports.size()]);
        }
    }
}

