/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave;

import brave.sampler.CountingSampler;
import brave.sampler.Sampler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.sleuth.autoconfig.brave.SamplerCondition;
import org.springframework.cloud.sleuth.autoconfig.brave.SamplerProperties;
import org.springframework.cloud.sleuth.brave.sampler.ProbabilityBasedSampler;
import org.springframework.cloud.sleuth.brave.sampler.RateLimitingSampler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SamplerProperties.class})
class BraveSamplerConfiguration {
    BraveSamplerConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    Sampler sleuthTraceSampler() {
        return Sampler.NEVER_SAMPLE;
    }

    static Sampler samplerFromProps(SamplerProperties config) {
        if (config.getProbability() != null) {
            return CountingSampler.create((float)config.getProbability().floatValue());
        }
        return brave.sampler.RateLimitingSampler.create((int)config.getRate());
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={SamplerCondition.class})
    @ConditionalOnMissingBean(type={"org.springframework.cloud.context.scope.refresh.RefreshScope"})
    protected static class NonRefreshScopeSamplerConfiguration {
        protected NonRefreshScopeSamplerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return BraveSamplerConfiguration.samplerFromProps(config);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={SamplerCondition.class})
    @ConditionalOnBean(type={"org.springframework.cloud.context.scope.refresh.RefreshScope"})
    protected static class RefreshScopedSamplerConfiguration {
        protected RefreshScopedSamplerConfiguration() {
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.sleuth.sampler.refresh.enabled"}, matchIfMissing=true)
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return this.sampler(config);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.sleuth.sampler.refresh.enabled"}, havingValue="false")
        public Sampler defaultNonRefreshScopeTraceSampler(SamplerProperties config) {
            return this.sampler(config);
        }

        private Sampler sampler(SamplerProperties config) {
            if (config.getProbability() != null) {
                return new ProbabilityBasedSampler(config::getProbability);
            }
            return new RateLimitingSampler(config::getRate);
        }
    }
}

