/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave;

import brave.Tags;
import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.BaggagePropagationCustomizer;
import brave.baggage.CorrelationScopeConfig;
import brave.baggage.CorrelationScopeCustomizer;
import brave.baggage.CorrelationScopeDecorator;
import brave.context.slf4j.MDCScopeDecorator;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthBaggageProperties;
import org.springframework.cloud.sleuth.autoconfig.brave.SleuthPropagationProperties;
import org.springframework.cloud.sleuth.brave.propagation.PropagationFactorySupplier;
import org.springframework.cloud.sleuth.brave.propagation.PropagationType;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
class BraveBaggageConfiguration {
    static final Log logger = LogFactory.getLog(BraveBaggageConfiguration.class);
    static final String LOCAL_KEYS = "spring.sleuth.local-keys";
    static final String BAGGAGE_KEYS = "spring.sleuth.baggage-keys";
    static final String PROPAGATION_KEYS = "spring.sleuth.propagation-keys";
    static final String WHITELISTED_KEYS = "spring.sleuth.propagation.tag.whitelisted-keys";
    static final String WHITELISTED_MDC_KEYS = "spring.sleuth.log.slf4j.whitelisted-mdc-keys";

    BraveBaggageConfiguration() {
    }

    @Bean(value={"spring.sleuth.baggage-keys"})
    @ConfigurationProperties(value="spring.sleuth.baggage-keys")
    List<String> baggageKeys() {
        return new ArrayList<String>();
    }

    @Bean(value={"spring.sleuth.local-keys"})
    @ConfigurationProperties(value="spring.sleuth.local-keys")
    List<String> localKeys() {
        return new ArrayList<String>();
    }

    @Bean(value={"spring.sleuth.propagation-keys"})
    @ConfigurationProperties(value="spring.sleuth.propagation-keys")
    List<String> propagationKeys() {
        return new ArrayList<String>();
    }

    @Bean(value={"spring.sleuth.log.slf4j.whitelisted-mdc-keys"})
    @ConfigurationProperties(value="spring.sleuth.log.slf4j.whitelisted-mdc-keys")
    List<String> whiteListedMDCKeys() {
        return new ArrayList<String>();
    }

    @Bean
    @ConditionalOnMissingBean
    PropagationFactorySupplier defaultPropagationFactorySupplier(SleuthPropagationProperties properties) {
        if (properties.getType().contains(PropagationType.CUSTOM)) {
            throw new IllegalStateException("Please register a bean with the following signature [extends Propagation.Factory implements Propagation<String>] to override the default Sleuth behaviour or [implements PropagationFactorySupplier] to reuse it.");
        }
        return () -> B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();
    }

    @Bean
    @ConditionalOnMissingBean
    BaggagePropagation.FactoryBuilder baggagePropagationFactoryBuilder(PropagationFactorySupplier supplier) {
        return BaggagePropagation.newFactoryBuilder((Propagation.Factory)supplier.get());
    }

    @Bean
    @ConditionalOnMissingBean
    Propagation.Factory sleuthPropagationWithB3Baggage(BaggagePropagation.FactoryBuilder factoryBuilder, @Qualifier(value="spring.sleuth.baggage-keys") List<String> baggageKeys, @Qualifier(value="spring.sleuth.local-keys") List<String> localKeys, @Qualifier(value="spring.sleuth.propagation-keys") List<String> propagationKeys, SleuthBaggageProperties sleuthBaggageProperties, SleuthPropagationProperties sleuthPropagationProperties, PropagationFactorySupplier supplier, @Nullable List<BaggagePropagationCustomizer> baggagePropagationCustomizers) {
        Set<String> localFields = BraveBaggageConfiguration.redirectOldPropertyToNew(LOCAL_KEYS, localKeys, "spring.sleuth.baggage.local-fields", sleuthBaggageProperties.getLocalFields());
        for (String string : localFields) {
            factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.local((BaggageField)BaggageField.create((String)string)));
        }
        Set<String> remoteFields = BraveBaggageConfiguration.redirectOldPropertyToNew(PROPAGATION_KEYS, propagationKeys, "spring.sleuth.baggage.remote-fields", sleuthBaggageProperties.getRemoteFields());
        for (String fieldName : remoteFields) {
            factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)BaggageField.create((String)fieldName)));
        }
        if (!baggageKeys.isEmpty()) {
            logger.warn((Object)("'spring.sleuth.baggage-keys' will be removed in a future release.\nTo change header names define a @Bean of type " + BaggagePropagationConfig.SingleBaggageField.class.getName()));
            for (String key : baggageKeys) {
                factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.newBuilder((BaggageField)BaggageField.create((String)key)).addKeyName("baggage-" + key).addKeyName("baggage_" + key).build());
            }
        }
        if (baggagePropagationCustomizers != null) {
            for (BaggagePropagationCustomizer customizer : baggagePropagationCustomizers) {
                customizer.customize(factoryBuilder);
            }
        }
        Propagation.Factory factory = factoryBuilder.build();
        Propagation.Factory factoryFromSupplier = supplier.get();
        boolean hasB3 = sleuthPropagationProperties.getType().contains(PropagationType.B3);
        if (hasB3) {
            return factory;
        }
        return new BaggageFactoryWrapper(factory, factoryFromSupplier);
    }

    static Set<String> redirectOldPropertyToNew(String oldProperty, List<String> oldValue, String newProperty, List<String> newValue) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(newValue);
        if (!oldValue.isEmpty()) {
            logger.warn((Object)("'" + oldProperty + "' has been renamed to '" + newProperty + "' and will be removed in a future release."));
            result.addAll(oldValue);
        }
        return result;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={MDC.class})
    CorrelationScopeDecorator.Builder correlationScopeDecoratorBuilder() {
        return MDCScopeDecorator.newBuilder();
    }

    @Bean
    @ConditionalOnMissingBean(value={CorrelationScopeDecorator.class})
    @ConditionalOnBean(value={CorrelationScopeDecorator.Builder.class})
    @ConditionalOnProperty(value={"spring.sleuth.baggage.correlation-enabled"}, matchIfMissing=true)
    CurrentTraceContext.ScopeDecorator correlationScopeDecorator(@Qualifier(value="spring.sleuth.log.slf4j.whitelisted-mdc-keys") List<String> whiteListedMDCKeys, SleuthBaggageProperties sleuthBaggageProperties, CorrelationScopeDecorator.Builder correlationScopeDecoratorBuilder, @Nullable List<CorrelationScopeCustomizer> correlationScopeCustomizers) {
        Set<String> correlationFields = BraveBaggageConfiguration.redirectOldPropertyToNew(WHITELISTED_MDC_KEYS, whiteListedMDCKeys, "spring.sleuth.baggage.correlation-fields", sleuthBaggageProperties.getCorrelationFields());
        CorrelationScopeDecorator.Builder builder = correlationScopeDecoratorBuilder;
        for (String field : correlationFields) {
            builder.add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageField.create((String)field)).build());
        }
        if (correlationScopeCustomizers != null) {
            for (CorrelationScopeCustomizer customizer : correlationScopeCustomizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }

    static class BaggageFactoryWrapper
    extends Propagation.Factory {
        private final Propagation.Factory delegate;
        private final Propagation.Factory factoryFromSupplier;

        BaggageFactoryWrapper(Propagation.Factory delegate, Propagation.Factory factoryFromSupplier) {
            this.delegate = delegate;
            this.factoryFromSupplier = factoryFromSupplier;
        }

        public boolean supportsJoin() {
            return this.delegate.supportsJoin();
        }

        public boolean requires128BitTraceId() {
            return this.delegate.requires128BitTraceId();
        }

        public Propagation<String> get() {
            Propagation propagation = this.delegate.get();
            return this.delegateWithoutB3Baggage(this.factoryFromSupplier, propagation);
        }

        public TraceContext decorate(TraceContext context) {
            return this.delegate.decorate(context);
        }

        private <K> Propagation<K> delegateWithoutB3Baggage(final Propagation.Factory factoryFromSupplier, final Propagation<K> propagation) {
            return new Propagation<K>(){

                public List<K> keys() {
                    return propagation.keys();
                }

                public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, K> setter) {
                    return factoryFromSupplier.get().injector(setter);
                }

                public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, K> getter) {
                    return propagation.extractor(getter);
                }
            };
        }
    }

    static final class BaggageTagSpanHandler
    extends SpanHandler {
        final BaggageField[] fieldsToTag;

        BaggageTagSpanHandler(BaggageField[] fieldsToTag) {
            this.fieldsToTag = fieldsToTag;
        }

        public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
            for (BaggageField field : this.fieldsToTag) {
                Tags.BAGGAGE_FIELD.tag((Object)field, context, span);
            }
            return true;
        }
    }

    static class BaggageTagSpanHandlerCondition
    extends AnyNestedCondition {
        BaggageTagSpanHandlerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"spring.sleuth.propagation.tag.whitelisted-keys[0]"})
        static class WhitelistedKeysYamlListProperty {
            WhitelistedKeysYamlListProperty() {
            }
        }

        @ConditionalOnProperty(value={"spring.sleuth.propagation.tag.whitelisted-keys"})
        static class WhitelistedKeysProperty {
            WhitelistedKeysProperty() {
            }
        }

        @ConditionalOnProperty(value={"spring.sleuth.baggage.tag-fields[0]"})
        static class TagFieldsYamlListProperty {
            TagFieldsYamlListProperty() {
            }
        }

        @ConditionalOnProperty(value={"spring.sleuth.baggage.tag-fields"})
        static class TagFieldsProperty {
            TagFieldsProperty() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={BaggageTagSpanHandlerCondition.class})
    static class BaggageTagSpanHandlerConfiguration {
        BaggageTagSpanHandlerConfiguration() {
        }

        @Bean(value={"spring.sleuth.propagation.tag.whitelisted-keys"})
        @ConfigurationProperties(value="spring.sleuth.propagation.tag.whitelisted-keys")
        List<String> whiteListedKeys() {
            return new ArrayList<String>();
        }

        @Bean
        SpanHandler baggageTagSpanHandler(@Qualifier(value="spring.sleuth.propagation.tag.whitelisted-keys") List<String> whiteListedKeys, SleuthBaggageProperties sleuthBaggageProperties) {
            Set<String> tagFields = BraveBaggageConfiguration.redirectOldPropertyToNew(BraveBaggageConfiguration.WHITELISTED_KEYS, whiteListedKeys, "spring.sleuth.baggage.tag-fields", sleuthBaggageProperties.getTagFields());
            if (tagFields.isEmpty()) {
                return SpanHandler.NOOP;
            }
            return new BaggageTagSpanHandler((BaggageField[])tagFields.stream().map(BaggageField::create).toArray(BaggageField[]::new));
        }
    }
}

