/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRetryProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.RetryableRequestContext;
import org.springframework.cloud.client.loadbalancer.reactive.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.reactive.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.reactive.ExchangeFilterFunctionUtils;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryContext;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.Request;
import org.springframework.cloud.client.loadbalancer.reactive.Response;
import org.springframework.cloud.client.loadbalancer.reactive.RetryableExchangeFilterFunctionLoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.RetryableStatusCodeException;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetrySpec;

public class RetryableLoadBalancerExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final Log LOG = LogFactory.getLog(RetryableLoadBalancerExchangeFilterFunction.class);
    private static final List<Class<? extends Throwable>> exceptions = Arrays.asList(IOException.class, TimeoutException.class, RetryableStatusCodeException.class);
    private final LoadBalancerRetryPolicy retryPolicy;
    private final LoadBalancerRetryProperties retryProperties;
    private final ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory;

    public RetryableLoadBalancerExchangeFilterFunction(LoadBalancerRetryPolicy retryPolicy, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory, LoadBalancerRetryProperties retryProperties) {
        this.retryPolicy = retryPolicy;
        this.loadBalancerFactory = loadBalancerFactory;
        this.retryProperties = retryProperties;
    }

    public RetryableLoadBalancerExchangeFilterFunction(ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory, LoadBalancerRetryProperties retryProperties) {
        this.retryPolicy = new RetryableExchangeFilterFunctionLoadBalancerRetryPolicy(retryProperties);
        this.loadBalancerFactory = loadBalancerFactory;
        this.retryProperties = retryProperties;
    }

    public Mono<ClientResponse> filter(ClientRequest clientRequest, ExchangeFunction next) {
        LoadBalancerRetryContext loadBalancerRetryContext = new LoadBalancerRetryContext(clientRequest);
        Retry exchangeRetry = this.buildRetrySpec(this.retryProperties.getMaxRetriesOnSameServiceInstance(), true);
        Retry filterRetry = this.buildRetrySpec(this.retryProperties.getMaxRetriesOnNextServiceInstance(), false);
        URI originalUrl = clientRequest.url();
        String serviceId = originalUrl.getHost();
        if (serviceId == null) {
            String message = String.format("Request URI does not contain a valid hostname: %s", originalUrl.toString());
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)message);
            }
            return Mono.just((Object)ClientResponse.create((HttpStatus)HttpStatus.BAD_REQUEST).body(message).build());
        }
        DefaultRequest<RetryableRequestContext> lbRequest = new DefaultRequest<RetryableRequestContext>(new RetryableRequestContext(null));
        return Mono.defer(() -> this.choose(serviceId, lbRequest).flatMap(lbResponse -> {
            ServiceInstance instance = (ServiceInstance)lbResponse.getServer();
            lbRequest.setContext(new RetryableRequestContext(instance));
            if (instance == null) {
                String message = "LoadBalancer does not contain an instance for the service " + serviceId;
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("LoadBalancer does not contain an instance for the service " + serviceId));
                }
                return Mono.just((Object)ClientResponse.create((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body(message).build());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("LoadBalancer has retrieved the instance for service %s: %s", serviceId, instance.getUri()));
            }
            ClientRequest newRequest = ExchangeFilterFunctionUtils.buildClientRequest(clientRequest, LoadBalancerUriTools.reconstructURI(instance, originalUrl));
            return next.exchange(newRequest).map(clientResponse -> {
                loadBalancerRetryContext.setClientResponse((ClientResponse)clientResponse);
                if (this.shouldRetrySameServiceInstance(loadBalancerRetryContext)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Retrying on status code: %d", clientResponse.statusCode().value()));
                    }
                    throw new RetryableStatusCodeException();
                }
                return clientResponse;
            });
        }).map(clientResponse -> {
            loadBalancerRetryContext.setClientResponse((ClientResponse)clientResponse);
            if (this.shouldRetryNextServiceInstance(loadBalancerRetryContext)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Retrying on status code: %d", clientResponse.statusCode().value()));
                }
                throw new RetryableStatusCodeException();
            }
            return clientResponse;
        }).retryWhen(exchangeRetry)).retryWhen(filterRetry);
    }

    private Retry buildRetrySpec(int max, boolean transientErrors) {
        LoadBalancerRetryProperties.Backoff backoffProperties = this.retryProperties.getBackoff();
        if (backoffProperties.isEnabled()) {
            return RetrySpec.backoff((long)max, (Duration)backoffProperties.getMinBackoff()).filter(this::isRetryException).maxBackoff(backoffProperties.getMaxBackoff()).jitter(backoffProperties.getJitter()).transientErrors(transientErrors);
        }
        return RetrySpec.max((long)max).filter(this::isRetryException).transientErrors(transientErrors);
    }

    private boolean shouldRetrySameServiceInstance(LoadBalancerRetryContext loadBalancerRetryContext) {
        boolean shouldRetry;
        boolean bl = shouldRetry = this.retryPolicy.retryableStatusCode(loadBalancerRetryContext.getResponseStatusCode()) && this.retryPolicy.canRetryOnMethod(loadBalancerRetryContext.getRequestMethod()) && this.retryPolicy.canRetrySameServiceInstance(loadBalancerRetryContext);
        if (shouldRetry) {
            loadBalancerRetryContext.incrementRetriesSameServiceInstance();
        }
        return shouldRetry;
    }

    private boolean shouldRetryNextServiceInstance(LoadBalancerRetryContext loadBalancerRetryContext) {
        boolean shouldRetry;
        boolean bl = shouldRetry = this.retryPolicy.retryableStatusCode(loadBalancerRetryContext.getResponseStatusCode()) && this.retryPolicy.canRetryOnMethod(loadBalancerRetryContext.getRequestMethod()) && this.retryPolicy.canRetryNextServiceInstance(loadBalancerRetryContext);
        if (shouldRetry) {
            loadBalancerRetryContext.incrementRetriesNextServiceInstance();
            loadBalancerRetryContext.resetRetriesSameServiceInstance();
        }
        return shouldRetry;
    }

    private boolean isRetryException(Throwable throwable) {
        return exceptions.stream().anyMatch(exception -> exception.isInstance(throwable) || throwable != null && exception.isInstance(throwable.getCause()) || Exceptions.isRetryExhausted((Throwable)throwable));
    }

    protected Mono<Response<ServiceInstance>> choose(String serviceId, Request<RetryableRequestContext> request) {
        ReactiveLoadBalancer<ServiceInstance> loadBalancer = this.loadBalancerFactory.getInstance(serviceId);
        if (loadBalancer == null) {
            return Mono.just((Object)new EmptyResponse());
        }
        return Mono.from(loadBalancer.choose(request));
    }
}

