/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.assertj;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.function.Supplier;
import org.assertj.core.api.AssertProvider;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.assertj.AssertProviderApplicationContextInvocationHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public interface ApplicationContextAssertProvider<C extends ApplicationContext>
extends ApplicationContext,
AssertProvider<ApplicationContextAssert<C>>,
Closeable {
    @Deprecated(since="2.0.0", forRemoval=false)
    public ApplicationContextAssert<C> assertThat();

    public C getSourceApplicationContext();

    public <T extends C> T getSourceApplicationContext(Class<T> var1);

    public Throwable getStartupFailure();

    @Override
    public void close();

    public static <T extends ApplicationContextAssertProvider<C>, C extends ApplicationContext> T get(Class<T> type, Class<? extends C> contextType, Supplier<? extends C> contextSupplier) {
        return ApplicationContextAssertProvider.get(type, contextType, contextSupplier, new Class[0]);
    }

    public static <T extends ApplicationContextAssertProvider<C>, C extends ApplicationContext> T get(Class<T> type, Class<? extends C> contextType, Supplier<? extends C> contextSupplier, Class<?> ... additionalContextInterfaces) {
        Assert.notNull(type, (String)"Type must not be null");
        Assert.isTrue((boolean)type.isInterface(), (String)"Type must be an interface");
        Assert.notNull(contextType, (String)"ContextType must not be null");
        Assert.isTrue((boolean)contextType.isInterface(), (String)"ContextType must be an interface");
        Class<?>[] interfaces = ApplicationContextAssertProvider.merge(new Class[]{type, contextType}, additionalContextInterfaces);
        return (T)((ApplicationContextAssertProvider)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)new AssertProviderApplicationContextInvocationHandler(contextType, contextSupplier)));
    }

    private static Class<?>[] merge(Class<?>[] classes, Class<?>[] additional) {
        if (ObjectUtils.isEmpty((Object[])additional)) {
            return classes;
        }
        Class<?>[] result = Arrays.copyOf(classes, classes.length + additional.length);
        System.arraycopy(additional, 0, result, classes.length, additional.length);
        return result;
    }
}

