/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.build.Buildpack;
import org.springframework.boot.buildpack.platform.build.BuildpackCoordinates;
import org.springframework.boot.buildpack.platform.build.BuildpackMetadata;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.BuildpackResolverContext;
import org.springframework.boot.buildpack.platform.docker.type.Layer;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.util.Assert;

class BuilderBuildpack
implements Buildpack {
    private static final String PREFIX = "urn:cnb:builder:";
    private final BuildpackCoordinates coordinates;

    BuilderBuildpack(BuildpackMetadata buildpackMetadata) {
        this.coordinates = BuildpackCoordinates.fromBuildpackMetadata(buildpackMetadata);
    }

    @Override
    public BuildpackCoordinates getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void apply(IOConsumer<Layer> layers) throws IOException {
    }

    static @Nullable Buildpack resolve(BuildpackResolverContext context, BuildpackReference reference) {
        boolean unambiguous = reference.hasPrefix(PREFIX);
        BuilderReference builderReference = BuilderReference.of(unambiguous ? BuilderBuildpack.getSubReference(reference) : reference.toString());
        BuildpackMetadata buildpackMetadata = BuilderBuildpack.findBuildpackMetadata(context, builderReference);
        if (unambiguous) {
            Assert.state((buildpackMetadata != null ? 1 : 0) != 0, () -> "Buildpack '" + String.valueOf(reference) + "' not found in builder");
        }
        return buildpackMetadata != null ? new BuilderBuildpack(buildpackMetadata) : null;
    }

    private static String getSubReference(BuildpackReference reference) {
        String result = reference.getSubReference(PREFIX);
        Assert.state((result != null ? 1 : 0) != 0, (String)"'result' must not be null");
        return result;
    }

    private static @Nullable BuildpackMetadata findBuildpackMetadata(BuildpackResolverContext context, BuilderReference builderReference) {
        for (BuildpackMetadata candidate : context.getBuildpackMetadata()) {
            if (!builderReference.matches(candidate)) continue;
            return candidate;
        }
        return null;
    }

    static class BuilderReference {
        private final String id;
        private final @Nullable String version;

        BuilderReference(String id, @Nullable String version) {
            this.id = id;
            this.version = version;
        }

        public String toString() {
            return this.version != null ? this.id + "@" + this.version : this.id;
        }

        boolean matches(BuildpackMetadata candidate) {
            return this.id.equals(candidate.getId()) && (this.version == null || this.version.equals(candidate.getVersion()));
        }

        static BuilderReference of(String value) {
            if (value.contains("@")) {
                String[] parts = value.split("@");
                return new BuilderReference(parts[0], parts[1]);
            }
            return new BuilderReference(value, null);
        }
    }
}

